/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.util;

import java.io.PrintStream;
import java.util.Map;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenCharacter;
import org.nineml.coffeegrinder.tokens.TokenString;
import org.nineml.coffeegrinder.util.PriorityTreeBuilder;

public class PrintStreamTreeBuilder
extends PriorityTreeBuilder {
    protected String tab = "  ";
    protected String nl = "\n";
    private String indent = "";
    private StringBuilder sb = null;
    private PrintStream stream;

    public PrintStreamTreeBuilder() {
        this.stream = null;
    }

    public PrintStreamTreeBuilder(PrintStream stream) {
        this.stream = stream;
    }

    public void setStream(PrintStream stream) {
        if (this.stream != null) {
            throw new RuntimeException("Stream cannot be changed");
        }
        this.stream = stream;
    }

    @Override
    public void startNonterminal(NonterminalSymbol symbol, Map<String, String> attributes, int leftExtent, int rightExtent) {
        if (this.sb != null) {
            this.stream.printf("%s%s%s", this.indent, this.sb, this.nl);
            this.sb = null;
        }
        this.stream.printf("%s<%s", this.indent, symbol);
        for (String name : attributes.keySet()) {
            if ("name".equals(name)) continue;
            this.stream.printf(" %s=\"%s\"", name, attributes.get(name));
        }
        this.stream.printf(">%s", this.nl);
        this.indent = this.indent + this.tab;
    }

    @Override
    public void endNonterminal(NonterminalSymbol symbol, Map<String, String> attributes, int leftExtent, int rightExtent) {
        if (this.sb != null) {
            this.stream.printf("%s%s%s", this.indent, this.sb, this.nl);
            this.sb = null;
        }
        this.indent = this.indent.substring(this.tab.length());
        this.stream.printf("%s</%s>%s", this.indent, symbol, this.nl);
    }

    @Override
    public void token(Token token, Map<String, String> attributes) {
        if (this.sb == null) {
            this.sb = new StringBuilder();
        }
        if (token instanceof TokenCharacter) {
            int cp = ((TokenCharacter)token).getCodepoint();
            if (cp == 60 || cp == 62 || cp == 38 || cp <= 32) {
                this.sb.append(String.format("&#x%x;", cp));
            } else {
                this.sb.appendCodePoint(cp);
            }
        } else if (token instanceof TokenString) {
            this.sb.append(token.getValue());
        } else {
            this.sb.append(token.toString());
        }
    }
}

