/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.RightHandSide;
import org.nineml.coffeegrinder.parser.Rule;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;

public class RegexCompiler {
    private final List<Rule> sourceRules;
    private Graph dfa = null;

    public RegexCompiler(List<Rule> sourceRules) {
        this.sourceRules = sourceRules;
    }

    public String compile(NonterminalSymbol startSymbol) {
        if (startSymbol == null) {
            throw new NullPointerException("Cannot compile starting with null");
        }
        try {
            this.dfa = new Graph();
            Node start = this.dfa.getNode(startSymbol);
            this.dfa.addEdge(this.dfa.start, start, TerminalSymbol.EPSILON);
            this.expand(start, startSymbol);
            this.dfa.makeFinal();
            if (this.dfa.finish == null) {
                throw new ExpansionException("Failed to compute final state");
            }
            this.dfa.collapse();
            return "bang";
        }
        catch (ExpansionException ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    private void expand(Node start, NonterminalSymbol symbol) {
        boolean found = false;
        for (Rule rule : this.sourceRules) {
            if (!symbol.equals(rule.symbol)) continue;
            found = true;
            this.expand(start, rule.rhs);
        }
        if (!found) {
            throw new ExpansionException("No rule for " + symbol);
        }
    }

    private void expand(Node start, RightHandSide rhs) {
        ArrayList<NonterminalSymbol> todo = new ArrayList<NonterminalSymbol>();
        if (rhs.isEmpty()) {
            this.dfa.addEdge(start, this.dfa.getNode(), TerminalSymbol.EPSILON);
            return;
        }
        Node current = start;
        for (Symbol symbol : rhs.symbols) {
            Node next;
            if (symbol instanceof TerminalSymbol) {
                next = this.dfa.getNode();
                this.dfa.addEdge(current, next, (TerminalSymbol)symbol);
                current = next;
                continue;
            }
            if (!this.dfa.contains((NonterminalSymbol)symbol)) {
                todo.add((NonterminalSymbol)symbol);
            }
            next = this.dfa.getNode((NonterminalSymbol)symbol);
            this.dfa.addEdge(current, next, TerminalSymbol.EPSILON);
            current = next;
        }
        for (NonterminalSymbol symbol : todo) {
            this.expand(this.dfa.getNode(symbol), symbol);
        }
    }

    private static class Edge {
        public final TerminalSymbol label;
        public final Node from;
        public final Node to;

        public Edge(Node from, Node to, TerminalSymbol label) {
            this.label = label;
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return this.from.toString() + "-" + this.label + "->" + this.to;
        }
    }

    private static class FinalState
    extends Node {
        private FinalState() {
        }

        @Override
        public String toString() {
            return "\u29bf";
        }
    }

    private static class StartState
    extends Node {
        private StartState() {
        }

        @Override
        public String toString() {
            return "\u2b58";
        }
    }

    private static class Node {
        private static int nextId = 1;
        public final int id = nextId++;
        public final NonterminalSymbol label;
        public final ArrayList<Edge> edges;

        public Node() {
            this.label = null;
            this.edges = new ArrayList();
        }

        public Node(NonterminalSymbol symbol) {
            this.label = symbol;
            this.edges = new ArrayList();
        }

        public String toString() {
            if (this.label == null) {
                return "[" + this.id + "]";
            }
            return this.label.toString();
        }
    }

    private static class Graph {
        public final Node start = new StartState();
        public final HashSet<Node> nodes = new HashSet();
        public final HashMap<NonterminalSymbol, Node> nonterminalNodes;
        private FinalState finish = null;

        public Graph() {
            this.nodes.add(this.start);
            this.nonterminalNodes = new HashMap();
        }

        public boolean contains(NonterminalSymbol symbol) {
            return this.nonterminalNodes.containsKey(symbol);
        }

        public Node getNode() {
            Node node = new Node();
            this.nodes.add(node);
            return node;
        }

        public Node getNode(NonterminalSymbol symbol) {
            if (!this.nonterminalNodes.containsKey(symbol)) {
                Node node = new Node(symbol);
                this.nodes.add(node);
                this.nonterminalNodes.put(symbol, node);
            }
            return this.nonterminalNodes.get(symbol);
        }

        public FinalState getFinalState() {
            if (this.finish == null) {
                this.finish = new FinalState();
                this.nodes.add(this.finish);
            }
            return this.finish;
        }

        public void addEdge(Node from, Node to, TerminalSymbol label) {
            Edge edge = new Edge(from, to, label);
            from.edges.add(edge);
        }

        public void makeFinal() {
            ArrayList<Node> terminalStates = new ArrayList<Node>();
            for (Node node : this.nodes) {
                if (!node.edges.isEmpty()) continue;
                terminalStates.add(node);
            }
            for (Node node : terminalStates) {
                this.addEdge(node, this.getFinalState(), TerminalSymbol.EPSILON);
            }
        }

        public void collapse() {
            this.makeEdgesUnique();
            HashSet<Node> remaining = new HashSet<Node>();
            boolean done = false;
            while (!done) {
                remaining.clear();
                done = true;
                HashSet<Node> iter = new HashSet<Node>(this.nodes);
                HashSet<Node> fixup = new HashSet<Node>();
                for (Node node : iter) {
                    if (node == this.start || node == this.finish) {
                        remaining.add(node);
                        continue;
                    }
                    Edge epsilonEdge = null;
                    ArrayList<Edge> saveEdges = new ArrayList<Edge>();
                    for (Edge edge : node.edges) {
                        if (epsilonEdge == null && edge.label.equals(TerminalSymbol.EPSILON) && !edge.to.equals(this.finish)) {
                            epsilonEdge = edge;
                            continue;
                        }
                        saveEdges.add(edge);
                    }
                    if (epsilonEdge != null) {
                        done = false;
                        for (Edge edge : saveEdges) {
                            this.addEdge(epsilonEdge.to, edge.to, edge.label);
                        }
                        this.relink(node, epsilonEdge.to);
                        fixup.add(epsilonEdge.to);
                        continue;
                    }
                    remaining.add(node);
                }
                this.nodes.clear();
                this.nodes.addAll(remaining);
                for (Node tofix : fixup) {
                    this.makeEdgesUnique(tofix);
                }
            }
        }

        private void relink(Node from, Node to) {
            for (Node node : this.nodes) {
                ArrayList<Edge> newEdges = new ArrayList<Edge>();
                for (Edge edge : node.edges) {
                    if (from.equals(edge.to)) {
                        newEdges.add(new Edge(edge.from, to, edge.label));
                        continue;
                    }
                    newEdges.add(edge);
                }
                node.edges.clear();
                node.edges.addAll(newEdges);
            }
        }

        private void makeEdgesUnique() {
            HashSet<Node> initial = new HashSet<Node>(this.nodes);
            for (Node node : initial) {
                this.makeEdgesUnique(node);
            }
        }

        private void makeEdgesUnique(Node node) {
            if (node.edges.size() < 2) {
                return;
            }
            ArrayList<Edge> newEdges = new ArrayList<Edge>();
            HashSet<TerminalSymbol> labels = new HashSet<TerminalSymbol>();
            for (Edge edge : node.edges) {
                if (edge.label.equals(TerminalSymbol.EPSILON)) {
                    newEdges.add(edge);
                    continue;
                }
                labels.add(edge.label);
            }
            if (labels.size() == node.edges.size()) {
                return;
            }
            for (TerminalSymbol label : labels) {
                ArrayList<Edge> dupEdges = new ArrayList<Edge>();
                for (Edge edge : node.edges) {
                    if (!label.equals(edge.label)) continue;
                    boolean redundant = false;
                    for (Edge dedge : dupEdges) {
                        redundant = edge.to.equals(dedge.to);
                        if (!redundant) continue;
                        break;
                    }
                    if (redundant) continue;
                    dupEdges.add(edge);
                }
                if (dupEdges.size() == 1) {
                    newEdges.addAll(dupEdges);
                    continue;
                }
                ArrayList<Node> discard = new ArrayList<Node>();
                Node intermediate = this.getNode();
                newEdges.add(new Edge(node, intermediate, label));
                for (Edge dedge : dupEdges) {
                    discard.add(dedge.to);
                    for (Edge transitive : dedge.to.edges) {
                        this.addEdge(intermediate, transitive.to, transitive.label);
                    }
                }
                for (Node dnode : discard) {
                    this.nodes.remove(dnode);
                }
            }
            node.edges.clear();
            node.edges.addAll(newEdges);
        }
    }

    private static class ExpansionException
    extends RuntimeException {
        public ExpansionException(String message) {
            super(message);
        }
    }
}

