/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.util;

import java.util.Calendar;

public class StopWatch {
    private static final int MS = 1000;
    private static final int MINMS = 60000;
    private static final int HOURMS = 3600000;
    private static final int DAYMS = 86400000;
    private final long startTime = Calendar.getInstance().getTimeInMillis();
    private long endTime = 0L;

    public void stop() {
        this.endTime = Calendar.getInstance().getTimeInMillis();
    }

    public long duration() {
        if (this.endTime != 0L) {
            return this.endTime - this.startTime;
        }
        return Calendar.getInstance().getTimeInMillis() - this.startTime;
    }

    public String perSecond(long events) {
        if (this.duration() == 0L) {
            return "\u221e";
        }
        return String.format("%3.1f", 1.0 * (double)events / ((double)this.duration() / 1000.0));
    }

    public String elapsed() {
        return this.elapsed(this.duration());
    }

    public String elapsed(long duration) {
        long days = this.floorDiv(duration, 86400000L);
        long left = duration - days * 86400000L;
        long hours = this.floorDiv(left, 3600000L);
        long minutes = this.floorDiv(left -= hours * 3600000L, 60000L);
        left -= minutes * 60000L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d");
        }
        if (days > 0L || hours > 0L) {
            sb.append(hours).append("h");
        }
        if (days > 0L || hours > 0L || minutes > 0L) {
            sb.append(minutes).append("m");
        }
        sb.append(String.format("%1.2f", 1.0 * (double)left / 1000.0)).append("s");
        return sb.toString();
    }

    private long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }
}

