/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.logging;

import java.util.ArrayList;
import java.util.List;
import org.nineml.logging.Logger;

public class CachingLogger
extends Logger {
    private final ArrayList<String> messages = new ArrayList();

    public List<String> getMessages() {
        return this.messages;
    }

    public void clearMessages() {
        this.messages.clear();
    }

    @Override
    public void error(String category, String format, Object ... params) {
        if (this.getLogLevel(category) >= 1) {
            this.messages.add(this.message(category, 1, format, params));
        }
    }

    @Override
    public void warn(String category, String format, Object ... params) {
        if (this.getLogLevel(category) >= 2) {
            this.messages.add(this.message(category, 2, format, params));
        }
    }

    @Override
    public void info(String category, String format, Object ... params) {
        if (this.getLogLevel(category) >= 3) {
            this.messages.add(this.message(category, 3, format, params));
        }
    }

    @Override
    public void debug(String category, String format, Object ... params) {
        if (this.getLogLevel(category) >= 4) {
            this.messages.add(this.message(category, 4, format, params));
        }
    }

    @Override
    public void trace(String category, String format, Object ... params) {
        if (this.getLogLevel(category) >= 5) {
            this.messages.add(this.message(category, 5, format, params));
        }
    }
}

