/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.logging;

import java.util.HashMap;
import java.util.Set;

public abstract class Logger {
    public static final String logcategory = "Logger";
    public static final String defaultLogLevelProperty = "org.nineml.logging.defaultLogLevel";
    public static final String logLevelsProperty = "org.nineml.logging.logLevels";
    public static final int SILENT = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static final int TRACE = 5;
    private static final HashMap<String, Integer> levelNames = new HashMap();
    private int defaultLogLevel = 1;
    private final HashMap<String, Integer> logLevels = new HashMap();

    public void readSystemProperties() {
        String value = System.getProperty(defaultLogLevelProperty);
        if (value != null) {
            this.defaultLogLevel = this.logLevelNumber(value);
        }
        if ((value = System.getProperty(logLevelsProperty)) != null) {
            this.setLogLevels(value);
        }
    }

    private int logLevelNumber(String name) {
        if (Character.isDigit(name.charAt(0))) {
            try {
                int value = Integer.parseInt(name);
                return Math.max(0, value);
            }
            catch (NumberFormatException ex) {
                this.error(logcategory, "Failed to parse log level: %s", name);
                return 1;
            }
        }
        if (levelNames.containsKey(name)) {
            return levelNames.get(name);
        }
        this.error(logcategory, "Unknown log level specified: %s", name);
        return 1;
    }

    public int getDefaultLogLevel() {
        return this.defaultLogLevel;
    }

    public void setDefaultLogLevel(int level) {
        this.defaultLogLevel = Math.max(0, level);
    }

    public void setDefaultLogLevel(String level) {
        if (level == null) {
            throw new NullPointerException("The level must not be null");
        }
        this.setDefaultLogLevel(this.logLevelNumber(level));
    }

    public Set<String> getLogCategories() {
        return this.logLevels.keySet();
    }

    public int getLogLevel(String category) {
        if (category == null) {
            throw new NullPointerException("The category must not be null");
        }
        return this.logLevels.getOrDefault(category.toLowerCase(), this.defaultLogLevel);
    }

    public void setLogLevel(String category, int level) {
        if (category == null) {
            throw new NullPointerException("The category must not be null");
        }
        this.logLevels.put(category.toLowerCase(), Math.max(0, level));
    }

    public void setLogLevel(String category, String level) {
        this.setLogLevel(category, this.logLevelNumber(level));
    }

    public void setLogLevels(String config) {
        if (config == null) {
            return;
        }
        for (String pair : config.split("[,\\s]+")) {
            if (pair.contains(":")) {
                int pos = pair.indexOf(":");
                String name = pair.substring(0, pos);
                String value = pair.substring(pos + 1);
                if ("*".equals(name)) {
                    this.setDefaultLogLevel(value);
                    continue;
                }
                this.setLogLevel(name, value);
                continue;
            }
            this.error(logcategory, "Cannot parse log level setting: %s", pair);
        }
    }

    public void clearLogLevels() {
        this.logLevels.clear();
    }

    protected String message(String category, int level, String message, Object ... params) {
        StringBuilder sb = new StringBuilder();
        switch (level) {
            case 1: {
                sb.append("E: ");
                break;
            }
            case 2: {
                sb.append("W: ");
                break;
            }
            case 3: {
                sb.append("I: ");
                break;
            }
            case 4: {
                sb.append("D: ");
                break;
            }
            case 5: {
                sb.append("T: ");
                break;
            }
            default: {
                sb.append("X: ");
            }
        }
        sb.append(String.format(message, params));
        return sb.toString();
    }

    public abstract void error(String var1, String var2, Object ... var3);

    public abstract void warn(String var1, String var2, Object ... var3);

    public abstract void info(String var1, String var2, Object ... var3);

    public abstract void debug(String var1, String var2, Object ... var3);

    public abstract void trace(String var1, String var2, Object ... var3);

    static {
        levelNames.put("silent", 0);
        levelNames.put("error", 1);
        levelNames.put("warning", 2);
        levelNames.put("info", 3);
        levelNames.put("debug", 4);
        levelNames.put("trace", 5);
    }
}

