/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.logging;

import org.nineml.logging.Logger;
import org.slf4j.LoggerFactory;

public class SystemLogger
extends Logger {
    private final org.slf4j.Logger logger;
    private final java.util.logging.Logger jlogger;

    public SystemLogger() {
        this.logger = LoggerFactory.getLogger(SystemLogger.class);
        this.jlogger = null;
    }

    public SystemLogger(java.util.logging.Logger logger) {
        this.logger = null;
        this.jlogger = logger;
    }

    @Override
    public void error(String category, String format, Object ... params) {
        if (this.getLogLevel(category) >= 1) {
            String logmessage = this.message(category, 1, format, params);
            if (this.jlogger != null) {
                this.jlogger.severe(logmessage);
            } else {
                this.logger.error(logmessage);
            }
        }
    }

    @Override
    public void warn(String category, String format, Object ... params) {
        if (this.getLogLevel(category) >= 2) {
            String logmessage = this.message(category, 2, format, params);
            if (this.jlogger != null) {
                this.jlogger.warning(logmessage);
            } else {
                this.logger.warn(logmessage);
            }
        }
    }

    @Override
    public void info(String category, String format, Object ... params) {
        if (this.getLogLevel(category) >= 3) {
            String logmessage = this.message(category, 3, format, params);
            if (this.jlogger != null) {
                this.jlogger.info(logmessage);
            } else {
                this.logger.info(logmessage);
            }
        }
    }

    @Override
    public void debug(String category, String format, Object ... params) {
        if (this.getLogLevel(category) >= 4) {
            String logmessage = this.message(category, 4, format, params);
            if (this.jlogger != null) {
                this.jlogger.fine(logmessage);
            } else {
                this.logger.debug(logmessage);
            }
        }
    }

    @Override
    public void trace(String category, String format, Object ... params) {
        if (this.getLogLevel(category) >= 5) {
            String logmessage = this.message(category, 5, format, params);
            if (this.jlogger != null) {
                this.jlogger.fine(logmessage);
            } else {
                this.logger.debug(logmessage);
            }
        }
    }
}

