/*
 * Decompiled with CFR 0.152.
 */
package ninja.servlet;

import javax.validation.constraints.NotNull;
import ninja.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletCookieHelper {
    private static final Logger log;
    private static final ServletCookieFallbackHandler SERVLET_COOKIE_FALLBACK_HANDLER;

    public static javax.servlet.http.Cookie getCookie(String name, javax.servlet.http.Cookie[] cookies) {
        javax.servlet.http.Cookie returnCookie = null;
        if (cookies != null) {
            for (javax.servlet.http.Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                returnCookie = cookie;
                break;
            }
        }
        return returnCookie;
    }

    public static String getCookieValue(String name, javax.servlet.http.Cookie[] cookies) {
        javax.servlet.http.Cookie cookie = ServletCookieHelper.getCookie(name, cookies);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public static javax.servlet.http.Cookie convertNinjaCookieToServletCookie(Cookie cookie) {
        javax.servlet.http.Cookie servletCookie = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
        servletCookie.setMaxAge(cookie.getMaxAge());
        if (cookie.getComment() != null) {
            servletCookie.setComment(cookie.getComment());
        }
        if (cookie.getDomain() != null) {
            servletCookie.setDomain(cookie.getDomain());
        }
        if (cookie.isSecure()) {
            servletCookie.setSecure(true);
        }
        if (cookie.getPath() != null) {
            servletCookie.setPath(cookie.getPath());
        }
        if (cookie.isHttpOnly()) {
            SERVLET_COOKIE_FALLBACK_HANDLER.setHttpOnly(servletCookie);
        }
        return servletCookie;
    }

    public static Cookie convertServletCookieToNinjaCookie(@NotNull javax.servlet.http.Cookie cookie) {
        Cookie.Builder ninjaCookieBuilder = Cookie.builder((String)cookie.getName(), (String)cookie.getValue());
        ninjaCookieBuilder.setMaxAge(cookie.getMaxAge());
        if (cookie.getComment() != null) {
            ninjaCookieBuilder.setComment(cookie.getComment());
        }
        if (cookie.getDomain() != null) {
            ninjaCookieBuilder.setDomain(cookie.getDomain());
        }
        ninjaCookieBuilder.setSecure(cookie.getSecure());
        if (cookie.getPath() != null) {
            ninjaCookieBuilder.setPath(cookie.getPath());
        }
        boolean isHttpOnly = SERVLET_COOKIE_FALLBACK_HANDLER.isHttpOnly(cookie);
        ninjaCookieBuilder.setHttpOnly(isHttpOnly);
        return ninjaCookieBuilder.build();
    }

    public static void setHttpOnly(javax.servlet.http.Cookie cookie) {
        SERVLET_COOKIE_FALLBACK_HANDLER.setHttpOnly(cookie);
    }

    static {
        ServletCookieFallbackHandler httpOnlySetter;
        log = LoggerFactory.getLogger(ServletCookieHelper.class);
        try {
            javax.servlet.http.Cookie.class.getMethod("setHttpOnly", Boolean.TYPE);
            httpOnlySetter = new Servlet3CookieFallbackHandler();
        }
        catch (NoSuchMethodException e) {
            httpOnlySetter = new Servlet25CookieFallbackHandler();
        }
        SERVLET_COOKIE_FALLBACK_HANDLER = httpOnlySetter;
    }

    private static class Servlet25CookieFallbackHandler
    implements ServletCookieFallbackHandler {
        private boolean warningAlreadyPrintedOut = false;

        private Servlet25CookieFallbackHandler() {
        }

        @Override
        public void setHttpOnly(javax.servlet.http.Cookie cookie) {
            this.printWarning();
        }

        @Override
        public boolean isHttpOnly(javax.servlet.http.Cookie cookie) {
            this.printWarning();
            return false;
        }

        private void printWarning() {
            if (!this.warningAlreadyPrintedOut) {
                log.warn("Running inside Servlet 2.5 container. Ignoring HttpSecure and HttpOnly for now.");
                this.warningAlreadyPrintedOut = true;
            }
        }
    }

    private static class Servlet3CookieFallbackHandler
    implements ServletCookieFallbackHandler {
        private Servlet3CookieFallbackHandler() {
        }

        @Override
        public void setHttpOnly(javax.servlet.http.Cookie cookie) {
            cookie.setHttpOnly(true);
        }

        @Override
        public boolean isHttpOnly(javax.servlet.http.Cookie cookie) {
            return cookie.isHttpOnly();
        }
    }

    private static interface ServletCookieFallbackHandler {
        public void setHttpOnly(javax.servlet.http.Cookie var1);

        public boolean isHttpOnly(javax.servlet.http.Cookie var1);
    }
}

