/*
 * Decompiled with CFR 0.152.
 */
package ninja.servlet.async;

import javax.servlet.http.HttpServletRequest;
import ninja.servlet.async.AsyncStrategy;
import ninja.servlet.async.AsyncStrategyFactory;
import ninja.servlet.async.BlockingAsyncStrategy;
import ninja.servlet.async.Servlet3AsyncStrategy;
import ninja.utils.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncStrategyFactoryHolder {
    private static final Logger log = LoggerFactory.getLogger(AsyncStrategyFactoryHolder.class);
    private static volatile AsyncStrategyFactory instance;

    public static AsyncStrategyFactory getInstance(HttpServletRequest request) {
        if (instance == null) {
            AsyncStrategyFactory factory;
            if (AsyncStrategyFactoryHolder.isAsyncSupported(request)) {
                factory = new AsyncStrategyFactory(){

                    @Override
                    public AsyncStrategy createStrategy(HttpServletRequest request, ResultHandler resultHandler) {
                        return new Servlet3AsyncStrategy(resultHandler, request);
                    }
                };
            } else {
                log.warn("Servlet 3 container not detected, async controllers will block");
                factory = new AsyncStrategyFactory(){

                    @Override
                    public AsyncStrategy createStrategy(HttpServletRequest request, ResultHandler resultHandler) {
                        return new BlockingAsyncStrategy();
                    }
                };
            }
            instance = factory;
        }
        return instance;
    }

    private static boolean isAsyncSupported(HttpServletRequest request) {
        try {
            return request.isAsyncSupported();
        }
        catch (LinkageError error) {
            return false;
        }
    }
}

