/*
 * Decompiled with CFR 0.152.
 */
package ninja.servlet.async;

import javax.servlet.http.HttpServletRequest;
import ninja.Context;
import ninja.Result;
import ninja.servlet.async.AsyncStrategy;
import ninja.utils.ResultHandler;

public class Servlet3AsyncStrategy
implements AsyncStrategy {
    private final ResultHandler resultHandler;
    private final HttpServletRequest request;

    public Servlet3AsyncStrategy(ResultHandler resultHandler, HttpServletRequest request) {
        this.resultHandler = resultHandler;
        this.request = request;
    }

    @Override
    public void handleAsync() {
        this.request.startAsync();
    }

    @Override
    public Result controllerReturned() {
        return null;
    }

    @Override
    public void returnResultAsync(Result result, Context context) {
        this.resultHandler.handleResult(result, context);
        this.request.getAsyncContext().complete();
    }
}

