/*
 * Decompiled with CFR 0.152.
 */
package ninja.websockets.jsr356;

import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import ninja.websockets.jsr356.Jsr356Handshake;
import ninja.websockets.jsr356.Jsr356HandshakePrincipal;

public class Jsr356DelegatingEndpoint
extends Endpoint {
    private Jsr356Handshake handshake;

    public void verify(Session session) {
        if (this.handshake == null) {
            this.handshake = Jsr356HandshakePrincipal.unwrapHandshake(session).orElse(null);
        }
        if (this.handshake == null) {
            throw new IllegalStateException("No websocket handshake exists. Something appears to be broken in how your HTTP container handles websocket handshakes.");
        }
        if (this.handshake.getEndpoint() == null) {
            throw new IllegalStateException("No websocket endpoint exists to delegate to. An endpoint must have either not been created in Ninja or  your HTTP container failed to pass along the value during the websocket handshake process.");
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.verify(session);
        this.handshake.getEndpoint().onOpen(session, config);
    }

    public void onError(Session session, Throwable cause) {
        this.verify(session);
        this.handshake.getEndpoint().onError(session, cause);
    }

    public void onClose(Session session, CloseReason close) {
        this.verify(session);
        this.handshake.getEndpoint().onClose(session, close);
    }
}

