/*
 * Decompiled with CFR 0.152.
 */
package ninja.websockets.jsr356;

import java.security.Principal;
import java.util.Optional;
import javax.websocket.Session;
import ninja.websockets.jsr356.Jsr356Handshake;

public class Jsr356HandshakePrincipal
implements Principal {
    private final Principal principal;
    private final Jsr356Handshake handshake;

    public Jsr356HandshakePrincipal(Principal principal, Jsr356Handshake handshake) {
        this.principal = principal;
        this.handshake = handshake;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Jsr356Handshake getHandshake() {
        return this.handshake;
    }

    @Override
    public String getName() {
        return "jsr356-handshake";
    }

    private static Optional<Jsr356HandshakePrincipal> unwrap(Session session) {
        Principal userPrincipal = session.getUserPrincipal();
        if (userPrincipal != null && userPrincipal instanceof Jsr356HandshakePrincipal) {
            return Optional.of((Jsr356HandshakePrincipal)userPrincipal);
        }
        return Optional.empty();
    }

    public static Optional<Jsr356Handshake> unwrapHandshake(Session session) {
        return Jsr356HandshakePrincipal.unwrap(session).map(s -> s.getHandshake()).filter(o -> o instanceof Jsr356Handshake).map(o -> o);
    }
}

