/*
 * Decompiled with CFR 0.152.
 */
package ninja.websockets.jsr356;

import java.util.List;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import ninja.websockets.jsr356.Jsr356DelegatingEndpoint;
import ninja.websockets.jsr356.Jsr356Handshake;
import ninja.websockets.jsr356.Jsr356HandshakeThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jsr356ServerEndpointConfigurator
extends ServerEndpointConfig.Configurator {
    private static final Logger log = LoggerFactory.getLogger(Jsr356ServerEndpointConfigurator.class);

    public boolean checkOrigin(String originHeaderValue) {
        log.trace("checkOrigin: {}", (Object)originHeaderValue);
        return super.checkOrigin(originHeaderValue);
    }

    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        log.trace("negotiatedSubprotocol: supported={}, requested={}", supported, requested);
        Jsr356Handshake handshake = Jsr356HandshakeThreadLocal.get();
        log.trace("using thread local handshake {}", (Object)handshake);
        String selectedSubprotocol = handshake.getSelectedProtocol();
        log.trace("returning selected protocol {}", (Object)selectedSubprotocol);
        return selectedSubprotocol;
    }

    public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        log.trace("negotiatedExtensions: installed={}, requested={}", installed, requested);
        return super.getNegotiatedExtensions(installed, requested);
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        log.trace("modifyHandshake");
        super.modifyHandshake(sec, request, response);
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        log.trace("endpointInstance");
        return (T)((Object)new Jsr356DelegatingEndpoint());
    }
}

