/*
 * Decompiled with CFR 0.152.
 */
package ninja.websockets.jsr356;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import ninja.Route;
import ninja.websockets.WebSockets;
import ninja.websockets.jsr356.Jsr356ServerEndpointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Jsr356WebSockets
implements WebSockets {
    private static final Logger log = LoggerFactory.getLogger(Jsr356WebSockets.class);
    private final ServerContainer serverContainer;

    @Inject
    public Jsr356WebSockets(ServerContainer serverContainer) {
        Objects.requireNonNull(serverContainer, "serverContainer was null");
        this.serverContainer = serverContainer;
    }

    public ServerContainer getServerContainer() {
        return this.serverContainer;
    }

    public boolean isEnabled() {
        return true;
    }

    public void compileRoute(Route route) {
        log.debug("Adding websocket to {} with endpoint {} in server container {}", new Object[]{route.getUri(), route.getControllerClass(), this.serverContainer.getClass().getCanonicalName()});
        Class endpointClass = route.getControllerClass();
        if (!Endpoint.class.isAssignableFrom(endpointClass)) {
            throw new IllegalArgumentException("WebSocket controller class must be of type " + Endpoint.class.getCanonicalName());
        }
        try {
            this.serverContainer.addEndpoint((ServerEndpointConfig)new Jsr356ServerEndpointConfig(route));
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }
}

