/*
 * Decompiled with CFR 0.152.
 */
package org.nlp2rdf.bean;

import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.nlp2rdf.bean.NIFContext;
import org.nlp2rdf.bean.NIFType;
import org.nlp2rdf.validator.NIFBeanContextValidator;
import org.nlp2rdf.validator.NIFBeanNumbersValidator;
import org.nlp2rdf.validator.NIFMessagesException;

public class NIFBean
implements NIFMessagesException {
    private NIFContext context;
    private String annotator;
    private String mention;
    private Integer beginIndex;
    private Integer endIndex;
    private NIFType nifType = NIFType.ENTITY;
    private List<String> types;
    private Double score;
    private String taIdentRef;
    private List<String> taClassRef;
    private String referenceContext;
    private String referenceContextId;
    private Map<String, String> entityTypes = new HashMap<String, String>(8);

    public String getReferenceContextId() {
        return this.referenceContextId;
    }

    public NIFBean(List<NIFBeanBuilder> builders) {
        ArrayList<NIFBean> nifBeans = new ArrayList<NIFBean>();
        for (NIFBeanBuilder builder : builders) {
            nifBeans.add(new NIFBean(builder));
        }
    }

    public List<String> getTaClassRef() {
        return this.taClassRef;
    }

    public NIFBean(NIFBeanBuilder builder) {
        this.init();
        this.setNifType(builder.nifType);
        this.setContext(builder.context);
        this.setMention(builder.mention);
        this.setBeginIndex(builder.beginIndex);
        this.setEndIndex(builder.endIndex);
        this.setTypes(builder.types);
        this.setScore(builder.score);
        this.setTaIdentRef(builder.taIdentRef);
        this.setReferenceContext(builder.referenceContext);
        this.setAnnotator(builder.annotator);
        this.setTaClassRef(builder.taClassRef);
    }

    public static void validate(List<NIFBean> beans) {
        NIFBeanNumbersValidator.checkIfEndIndexIsGreaterThanBeginIndex(beans);
        NIFBeanContextValidator.checkIfContextExists(beans);
        NIFBeanContextValidator.checkIfHasDuplicatedContext(beans);
    }

    public static void fillBeansWithContext(List<NIFBean> beans, String CONTEXT_FORMAT) {
        for (NIFBean bean : beans) {
            if (bean == null || !NIFType.CONTEXT.equals((Object)bean.getNifType())) continue;
            bean.setReferenceContext(bean.getContext().context(CONTEXT_FORMAT));
        }
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    private void init() {
        this.entityTypes.put("PERSON", "http://nerd.eurecom.fr/ontology#Person");
        this.entityTypes.put("ORGANIZATION", "http://nerd.eurecom.fr/ontology#Organization");
        this.entityTypes.put("LOCATION", "http://nerd.eurecom.fr/ontology#Location");
        this.entityTypes.put("MISC", "http://www.w3.org/2002/07/owl#Thing");
        this.entityTypes.put("I-PER", "http://nerd.eurecom.fr/ontology#Person");
        this.entityTypes.put("I-ORG", "http://nerd.eurecom.fr/ontology#Organization");
        this.entityTypes.put("I-LOC", "http://nerd.eurecom.fr/ontology#Location");
        this.entityTypes.put("I-MISC", "http://www.w3.org/2002/07/owl#Thing");
    }

    public Boolean hasTypes() {
        return this.types != null && !this.types.isEmpty();
    }

    public Boolean hasTaClassRef() {
        return this.taClassRef != null && !this.taClassRef.isEmpty();
    }

    public Boolean hasTaIdentRef() {
        return this.taIdentRef != null;
    }

    public Boolean hasScore() {
        return this.score != null;
    }

    public String getMention() {
        return this.mention;
    }

    public void setMention(String mention) {
        Objects.requireNonNull(mention, String.format("NIF 1000 - Null is not accepted for %s", "Mention"));
        this.mention = mention;
    }

    public Integer getBeginIndex() {
        return this.beginIndex;
    }

    public void setBeginIndex(Integer beginIndex) {
        if (this.isMention().booleanValue()) {
            Objects.requireNonNull(beginIndex, String.format("NIF 1000 - Null is not accepted for %s", "beginIndex"));
        }
        this.beginIndex = beginIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(Integer endIndex) {
        if (this.isMention().booleanValue()) {
            Objects.requireNonNull(this.beginIndex, String.format("NIF 1000 - Null is not accepted for %s", "endIndex"));
        }
        this.endIndex = endIndex;
    }

    public Boolean isMention() {
        return NIFType.ENTITY.equals((Object)this.nifType);
    }

    public Boolean isContext() {
        return NIFType.CONTEXT.equals((Object)this.nifType);
    }

    public NIFType getNifType() {
        return this.nifType;
    }

    public void setNifType(NIFType nifType) {
        this.nifType = nifType;
    }

    public String getTaIdentRef() {
        return this.taIdentRef;
    }

    public void setTaIdentRef(String taIdentRef) {
        this.taIdentRef = taIdentRef;
    }

    public String getReferenceContext() {
        return this.referenceContext;
    }

    public void setReferenceContext(String referenceContext) {
        if (referenceContext != null) {
            this.referenceContext = referenceContext;
            this.referenceContextId = Hashing.md5().hashBytes(referenceContext.getBytes()).toString();
        }
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        ArrayList<String> convertedTypes = new ArrayList<String>();
        if (types != null) {
            for (String type : types) {
                if (type == null) continue;
                convertedTypes.add(this.entityTypes.get(type));
            }
        }
        this.types = convertedTypes;
    }

    public NIFContext getContext() {
        return this.context;
    }

    public void setContext(NIFContext context) {
        Objects.requireNonNull(context, String.format("NIF 1000 - Null is not accepted for %s", "context"));
        this.context = context;
    }

    public String getAnnotator() {
        return this.annotator;
    }

    public void setAnnotator(String annotator) {
        this.annotator = annotator;
    }

    public void setTaClassRef(List<String> taClassRef) {
        this.taClassRef = taClassRef;
    }

    public static class NIFBeanBuilder {
        private String mention;
        private Integer beginIndex;
        private Integer endIndex;
        private NIFType nifType;
        private List<String> types;
        private Double score;
        private String taIdentRef;
        private String referenceContext;
        private String annotator;
        private NIFContext context;
        private List<String> taClassRef;

        public NIFBeanBuilder() {
            this.init();
        }

        public NIFBeanBuilder init() {
            this.mention = null;
            this.beginIndex = null;
            this.endIndex = null;
            this.nifType = NIFType.ENTITY;
            this.types = null;
            this.score = null;
            this.taIdentRef = null;
            this.context = null;
            this.annotator = null;
            this.taClassRef = null;
            return this;
        }

        public NIFBeanBuilder context(String baseURI, int beginIndex, int endIndex) {
            Objects.requireNonNull(baseURI, String.format("NIF 1000 - Null is not accepted for %s", "Base URI"));
            assert (beginIndex >= 0) : String.format("NIF 1001 - Negative numbers are not accepted as value for %s", "beginIndex");
            assert (endIndex >= 0) : String.format("NIF 1001 - Negative numbers are not accepted as value for %s", "endIndex");
            assert (endIndex > beginIndex) : String.format("NIF 1002 - %s must be greater than %s for %s", "beginIndex", "endIndex", "context");
            this.context = new NIFContext(baseURI, beginIndex, endIndex);
            return this;
        }

        public NIFBeanBuilder context(String baseURI) {
            Objects.requireNonNull(baseURI, String.format("NIF 1000 - Null is not accepted for %s", "Base URI"));
            this.context = new NIFContext(baseURI);
            return this;
        }

        public NIFBeanBuilder taIdentRef(String taIdentRef) {
            Objects.requireNonNull(taIdentRef, String.format("NIF 1000 - Null is not accepted for %s", "taIdentRef"));
            this.taIdentRef = taIdentRef;
            return this;
        }

        public NIFBeanBuilder mention(String mention) {
            Objects.requireNonNull(mention, String.format("NIF 1000 - Null is not accepted for %s", "Mention"));
            this.mention = mention;
            return this;
        }

        public NIFBeanBuilder beginIndex(Integer beginIndex) {
            Objects.requireNonNull(beginIndex, String.format("NIF 1000 - Null is not accepted for %s", "beginIndex"));
            assert (beginIndex >= 0) : String.format("NIF 1001 - Negative numbers are not accepted as value for %s", "beginIndex");
            this.beginIndex = beginIndex;
            return this;
        }

        public NIFBeanBuilder endIndex(Integer endIndex) {
            Objects.requireNonNull(this.beginIndex, String.format("NIF 1000 - Null is not accepted for %s", "endIndex"));
            assert (endIndex >= 0) : String.format("NIF 1001 - Negative numbers are not accepted as value for %s", "endIndex");
            this.endIndex = endIndex;
            return this;
        }

        public NIFBeanBuilder nifType(NIFType nifType) {
            Objects.requireNonNull(nifType, String.format("NIF 1000 - Null is not accepted for %s", "NIF Type"));
            this.nifType = nifType;
            return this;
        }

        public NIFBeanBuilder types(List<String> types) {
            this.types = types == null ? new ArrayList(1) : types;
            return this;
        }

        public NIFBeanBuilder taClassRef(List<String> taClassRef) {
            this.taClassRef = taClassRef;
            return this;
        }

        public NIFBeanBuilder score(Double score) {
            Objects.requireNonNull(score, String.format("NIF 1000 - Null is not accepted for %s", "score"));
            this.score = score;
            return this;
        }

        public NIFBeanBuilder referenceContext(String referenceContext) {
            Objects.requireNonNull(referenceContext, String.format("NIF 1000 - Null is not accepted for %s", "reference context"));
            this.referenceContext = referenceContext;
            return this;
        }

        public NIFBeanBuilder annotator(String annotator) {
            Objects.requireNonNull(annotator, String.format("NIF 1000 - Null is not accepted for %s", "annotator"));
            this.annotator = annotator;
            return this;
        }

        public NIFBean build() {
            return new NIFBean(this);
        }
    }
}

