/*
 * Decompiled with CFR 0.152.
 */
package org.nlp2rdf.bean;

import com.google.common.hash.Hashing;

public class NIFContext {
    private String baseURI;
    private int beginIndex;
    private int endIndex;

    public NIFContext(String baseURI, Integer beginIndex, Integer endIndex) {
        this.baseURI = baseURI;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.formatBaseURI();
    }

    public NIFContext(String baseURI) {
        this.baseURI = baseURI;
        this.formatBaseURI();
    }

    private void formatBaseURI() {
        if (this.baseURI != null && !this.baseURI.isEmpty() && !"/".equals(this.baseURI.substring(this.baseURI.length() - 1))) {
            this.baseURI = this.baseURI.concat("/");
        }
    }

    public String context(String format) {
        this.formatBaseURI();
        if (this.beginIndex == 0 && this.endIndex == 0) {
            return this.baseURI;
        }
        return String.format(format, this.baseURI, this.beginIndex, this.endIndex);
    }

    public String getCollection() {
        return String.format("%s#collection", this.baseURI);
    }

    public Integer getBeginIndex() {
        return this.beginIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public String getNIF20() {
        return this.context("%s#char=%d,%d");
    }

    public String getNIF20id() {
        return Hashing.md5().hashBytes(this.getNIF20().getBytes()).toString();
    }

    public String getNIF21() {
        return this.context("%s#offset_%d_%d");
    }

    public String getNIF21id() {
        return Hashing.md5().hashBytes(this.getNIF21().getBytes()).toString();
    }
}

