/*
 * Decompiled with CFR 0.152.
 */
package org.nlp2rdf.bean;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NIFJSONLDContext {
    private final String PREDICATE_RANGE = "http://www.w3.org/2000/01/rdf-schema#range";
    private Map<String, String> types;
    private Set<String> properties;
    private List<JSONLDContextBean> beans;

    private boolean isNotBlank(String data) {
        return data != null && !data.isEmpty();
    }

    public List<JSONLDContextBean> convertToBeans(Set<String> ontologies, String language) {
        OntModel model = ModelFactory.createOntologyModel();
        this.beans = new ArrayList<JSONLDContextBean>();
        this.types = new HashMap<String, String>();
        this.properties = new HashSet<String>();
        for (String ontology : ontologies) {
            model.read(ontology);
        }
        StmtIterator stms = model.listStatements();
        while (stms.hasNext()) {
            Statement s = (Statement)stms.next();
            if (!"http://www.w3.org/2000/01/rdf-schema#range".equals(s.getPredicate().toString())) continue;
            this.types.put(s.getSubject().toString(), s.getObject().toString());
        }
        ExtendedIterator datatypeProperties = model.listDatatypeProperties();
        while (datatypeProperties.hasNext()) {
            DatatypeProperty data = (DatatypeProperty)datatypeProperties.next();
            this.addToContext(data.getLocalName(), data.getURI(), data.getLabel(language), data.getComment(language), this.types != null ? data.getURI() : null);
        }
        ExtendedIterator transitiveProperties = model.listTransitiveProperties();
        while (transitiveProperties.hasNext()) {
            TransitiveProperty data = (TransitiveProperty)transitiveProperties.next();
            this.addToContext(data.getLocalName(), data.getURI(), data.getLabel(language), data.getComment(language), this.types != null ? data.getURI() : null);
        }
        ExtendedIterator objectProperties = model.listObjectProperties();
        while (objectProperties.hasNext()) {
            ObjectProperty data = (ObjectProperty)objectProperties.next();
            this.addToContext(data.getLocalName(), data.getURI(), data.getLabel(language), data.getComment(language), this.types != null ? data.getURI() : null);
        }
        ExtendedIterator classes = model.listClasses();
        while (classes.hasNext()) {
            OntClass data = (OntClass)classes.next();
            this.addToContext(data.getLocalName(), data.getURI(), data.getLabel(language), data.getComment(language), this.types != null ? data.getURI() : null);
        }
        ExtendedIterator annotationProperties = model.listAnnotationProperties();
        while (annotationProperties.hasNext()) {
            AnnotationProperty data = (AnnotationProperty)annotationProperties.next();
            this.addToContext(data.getLocalName(), data.getURI(), data.getLabel(language), data.getComment(language), this.types != null ? data.getURI() : null);
        }
        return this.beans;
    }

    private void addToContext(String localName, String uri, String label, String comment, String type) {
        if (this.isNotBlank(localName) && !this.properties.contains(localName)) {
            JSONLDContextBean bean = new JSONLDContextBean(localName, uri, label, comment, type);
            this.beans.add(bean);
            this.properties.add(localName);
        }
    }

    public class JSONLDContextBean {
        private String name;
        private String uri;
        private String label;
        private String comment;
        private String type;

        public JSONLDContextBean(String name, String uri, String label, String comment, String type) {
            this.setName(name);
            this.setUri(uri);
            this.setLabel(label);
            this.setComment(comment);
            this.setType(type);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label == null ? label : "";
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment == null ? comment : "";
        }
    }
}

