/*
 * Decompiled with CFR 0.152.
 */
package org.nlp2rdf.formats;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.nlp2rdf.bean.NIFBean;
import org.nlp2rdf.bean.NIFJSONLDContext;
import org.nlp2rdf.bean.NIFType;
import org.nlp2rdf.exception.NIFException;
import org.nlp2rdf.json.JSONMinify;

public class Conversor {
    protected String getRDFxml(Model model) {
        return this.getModelAsStringByFormat(model, Lang.RDFXML);
    }

    protected String getNTriples(Model model) {
        return this.getModelAsStringByFormat(model, Lang.NTRIPLES);
    }

    protected String getTurtle(Model model) {
        return this.getModelAsStringByFormat(model, Lang.TURTLE);
    }

    private String getModelAsStringByFormat(Model model, Lang lang) {
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (Model)model, (Lang)lang);
        String result = sw.toString();
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    protected String getJSONLD(String contextJSON, List<NIFBean> beans, String templatePath) {
        VelocityEngine velocityEngine = this.getVelocityEngine();
        Template template = velocityEngine.getTemplate(templatePath);
        VelocityContext context = new VelocityContext();
        if (beans.size() == 0) {
            throw new NIFException("NIF 3000 - You must provide almost one NIF bean to convert to json");
        }
        context.put("contextJSON", (Object)contextJSON);
        context.put("context", (Object)beans.get(0).getReferenceContext());
        context.put("beans", beans);
        String result = this.getStringFromVelocity(template, (Context)context);
        return JSONMinify.minify(result);
    }

    private void removeNIFContext(List<NIFBean> beans) {
        NIFBean nifContext = null;
        for (NIFBean bean : beans) {
            if (!NIFType.CONTEXT.equals((Object)bean.getNifType())) continue;
            nifContext = bean;
            break;
        }
        if (nifContext != null) {
            beans.remove(nifContext);
        }
    }

    private VelocityEngine getVelocityEngine() {
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.init();
        return velocityEngine;
    }

    protected String getContextForJSONLD(Set<String> ontologies, String templatePath, String language) {
        VelocityEngine velocityEngine = this.getVelocityEngine();
        Template template = velocityEngine.getTemplate(templatePath);
        VelocityContext context = new VelocityContext();
        context.put("contextBeans", new NIFJSONLDContext().convertToBeans(ontologies, language));
        String result = this.getStringFromVelocity(template, (Context)context);
        return JSONMinify.minify(result);
    }

    private String getStringFromVelocity(Template template, Context context) {
        StringWriter sw = new StringWriter();
        template.merge(context, (Writer)sw);
        String result = sw.toString();
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

