/*
 * Decompiled with CFR 0.152.
 */
package org.nlp2rdf.json;

public class JSONMinify {
    public static String minify(String jsonString) {
        boolean in_string = false;
        boolean in_multiline_comment = false;
        boolean in_singleline_comment = false;
        char string_opener = 'x';
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < jsonString.length(); ++i) {
            char c = jsonString.charAt(i);
            String cc = jsonString.substring(i, Math.min(i + 2, jsonString.length()));
            if (in_string) {
                if (c == string_opener) {
                    in_string = false;
                    out.append(c);
                    continue;
                }
                if (c == '\\') {
                    out.append(cc);
                    ++i;
                    continue;
                }
                out.append(c);
                continue;
            }
            if (in_singleline_comment) {
                if (c != '\r' && c != '\n') continue;
                in_singleline_comment = false;
                continue;
            }
            if (in_multiline_comment) {
                if (!cc.equals("*/")) continue;
                in_multiline_comment = false;
                ++i;
                continue;
            }
            if (cc.equals("/*")) {
                in_multiline_comment = true;
                ++i;
                continue;
            }
            if (cc.equals("//")) {
                in_singleline_comment = true;
                ++i;
                continue;
            }
            if (c == '\"' || c == '\'') {
                in_string = true;
                string_opener = c;
                out.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            out.append(c);
        }
        return out.toString();
    }
}

