/*
 * Decompiled with CFR 0.152.
 */
package org.nlp2rdf.nif20.impl;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.nlp2rdf.ContextJSONLD;
import org.nlp2rdf.NIF;
import org.nlp2rdf.NIFFormat;
import org.nlp2rdf.NIFVisitor;
import org.nlp2rdf.bean.NIFBean;
import org.nlp2rdf.formats.Conversor;
import org.nlp2rdf.nif20.NIF20Format;
import org.nlp2rdf.nif20.impl.NIF20CreateContext;
import org.nlp2rdf.nif20.impl.NIF20Literal;
import org.nlp2rdf.nif20.impl.NIF20Model;
import org.nlp2rdf.nif20.impl.NIF20Prefixes;
import org.nlp2rdf.nif20.impl.NIF20Properties;
import org.nlp2rdf.nif20.impl.NIF20Resource;
import org.nlp2rdf.parser.NIFParser;
import org.nlp2rdf.validator.NIFMessagesException;

public class NIF20
extends Conversor
implements NIF20Format,
NIFMessagesException,
NIF,
ContextJSONLD {
    private NIFFormat[] elements;
    private List<NIFBean> beans;
    private NIFParser parser;

    public NIF20() {
    }

    public NIF20(List<NIFBean> beans) {
        Objects.requireNonNull(beans, String.format("NIF 1000 - Null is not accepted for %s", "NIF Beans"));
        this.beans = beans;
        this.elements = new NIFFormat[]{new NIF20Resource(), new NIF20Prefixes(), new NIF20Properties(), new NIF20Literal()};
    }

    public NIF20(List<NIFBean> beans, NIFParser parser) {
        this(beans);
        this.parser = parser;
    }

    @Override
    public void accept(NIFVisitor visitor) {
        for (NIFFormat elem : this.elements) {
            elem.accept(visitor);
        }
    }

    @Override
    public Model getModel() {
        NIFBean.validate(this.beans);
        NIFBean.fillBeansWithContext(this.beans, "%s#char=%d,%d");
        NIF20Model model = new NIF20Model();
        NIFBean bean = this.beans.get(0);
        NIF20CreateContext nif20Context = new NIF20CreateContext(bean.getContext(), bean);
        nif20Context.setModel(model.create());
        NIF20CreateContext nifVisitor = nif20Context;
        if (this.parser != null) {
            this.parser.merge(nifVisitor.getModel());
        }
        this.accept(nifVisitor);
        for (int i = 1; i < this.beans.size(); ++i) {
            nif20Context.setBean(this.beans.get(i));
            this.accept(nifVisitor);
        }
        return nifVisitor.getModel();
    }

    @Override
    public String getNTriples() {
        return super.getNTriples(this.getModel());
    }

    @Override
    public String getRDFxml() {
        return super.getRDFxml(this.getModel());
    }

    @Override
    public String getTurtle() {
        return super.getTurtle(this.getModel());
    }

    @Override
    public String getTurtle(Model model) {
        return super.getTurtle(this.getModel());
    }

    @Override
    public String getJSONLD(String context) {
        super.getNTriples(this.getModel());
        return super.getJSONLD(context, this.beans, TEMPLATE_NIF_PATH);
    }

    @Override
    public String getContextForJSONLD(Set<String> ontologies, String language) {
        return super.getContextForJSONLD(ontologies, TEMPLATE_CONTEXT_PATH, language);
    }

    @Override
    public String getContextForJSONLD(Set<String> ontologies, String template, String language) {
        return super.getContextForJSONLD(ontologies, template, language);
    }
}

