/*
 * Decompiled with CFR 0.152.
 */
package org.nlp2rdf.nif20.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import org.nlp2rdf.NIFLiteral;
import org.nlp2rdf.NIFVisitor;
import org.nlp2rdf.bean.NIFBean;
import org.nlp2rdf.model.ModelMergeManager;
import org.nlp2rdf.nif20.NIF20Format;

public class NIF20Literal
implements NIFLiteral,
NIF20Format {
    @Override
    public void add(Model model, NIFBean entity) {
        if (model != null && entity != null) {
            Resource contextRes = model.getResource(entity.getContext().getNIF20());
            if (entity.isContext().booleanValue()) {
                ModelMergeManager.removeDuplicatedValues(model, contextRes, NIF_PROPERTY_ISSTRING, entity.getMention());
                ModelMergeManager.removeDuplicatedValues(model, contextRes, NIF_PROPERTY_BEGININDEX, entity.getMention());
                ModelMergeManager.removeDuplicatedValues(model, contextRes, NIF_PROPERTY_ENDINDEX, entity.getMention());
                contextRes.addLiteral(model.getProperty(NIF_PROPERTY_ISSTRING), (Object)entity.getMention());
                model.add(contextRes, model.createProperty(NIF_PROPERTY_BEGININDEX), entity.getContext().getBeginIndex().toString(), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
                model.add(contextRes, model.createProperty(NIF_PROPERTY_ENDINDEX), entity.getContext().getEndIndex().toString(), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
            } else if (entity.isMention().booleanValue()) {
                contextRes.addLiteral(model.createProperty(NIF_PROPERTY_ANCHOR_OF), (Object)entity.getMention());
                model.add(contextRes, model.createProperty(NIF_PROPERTY_BEGININDEX), entity.getContext().getBeginIndex().toString(), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
                model.add(contextRes, model.createProperty(NIF_PROPERTY_ENDINDEX), entity.getContext().getEndIndex().toString(), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
                if (entity.hasTypes().booleanValue()) {
                    for (String ref : entity.getTypes()) {
                        contextRes.addProperty(model.createProperty(RDF_PROPERTY_CLASS_REF), (RDFNode)model.createResource(ref));
                    }
                }
                if (entity.hasScore().booleanValue()) {
                    contextRes.addLiteral(model.createProperty(RDF_PROPERTY_CONFIDENCE), model.createTypedLiteral((Object)entity.getScore()));
                }
            }
        }
    }

    @Override
    public void accept(NIFVisitor visitor) {
        visitor.visit(this);
    }
}

