/*
 * Decompiled with CFR 0.152.
 */
package org.nlp2rdf.nif20.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import org.nlp2rdf.NIFProperties;
import org.nlp2rdf.NIFVisitor;
import org.nlp2rdf.bean.NIFBean;
import org.nlp2rdf.nif20.NIF20Format;

public class NIF20Properties
implements NIFProperties,
NIF20Format {
    @Override
    public void add(Model model, NIFBean entity) {
        if (model != null && entity != null) {
            Resource contextRes = model.getResource(entity.getContext().getNIF20());
            if (entity.isMention().booleanValue()) {
                this.fillMention(model, entity, contextRes);
            } else if (entity.isContext().booleanValue()) {
                this.fillContext(model, contextRes);
            }
        }
    }

    private void fillContext(Model model, Resource contextRes) {
        contextRes.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_STRING));
        contextRes.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_CONTEXT));
        contextRes.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_RFC5147));
    }

    private void fillMention(Model model, NIFBean entity, Resource contextRes) {
        contextRes.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_STRING));
        contextRes.addProperty(model.createProperty(NIF_PROPERTY_REFERENCE_CONTEXT), (RDFNode)model.createResource(entity.getReferenceContext()));
        if (entity.hasTaIdentRef().booleanValue()) {
            contextRes.addProperty(model.createProperty(RDF_PROPERTY_IDENTREF), (RDFNode)model.createResource(entity.getTaIdentRef()));
        }
        if (entity.hasTypes().booleanValue()) {
            for (String type : entity.getTypes()) {
                contextRes.addProperty(model.createProperty(RDF_PROPERTY_CLASS_REF), (RDFNode)model.createResource(type));
            }
        }
        contextRes.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_WORD));
        contextRes.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_PHRASE));
        contextRes.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_RFC5147));
    }

    @Override
    public void accept(NIFVisitor visitor) {
        visitor.visit(this);
    }
}

