/*
 * Decompiled with CFR 0.152.
 */
package org.nlp2rdf.nif21.impl;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.nlp2rdf.ContextJSONLD;
import org.nlp2rdf.NIF;
import org.nlp2rdf.NIFFormat;
import org.nlp2rdf.NIFVisitor;
import org.nlp2rdf.bean.NIFBean;
import org.nlp2rdf.formats.Conversor;
import org.nlp2rdf.nif21.NIF21Format;
import org.nlp2rdf.nif21.impl.NIF21AnnotationUnit;
import org.nlp2rdf.nif21.impl.NIF21CreateContext;
import org.nlp2rdf.nif21.impl.NIF21Literal;
import org.nlp2rdf.nif21.impl.NIF21Model;
import org.nlp2rdf.nif21.impl.NIF21Prefixes;
import org.nlp2rdf.nif21.impl.NIF21Properties;
import org.nlp2rdf.nif21.impl.NIF21Resource;
import org.nlp2rdf.parser.NIFParser;

public class NIF21
extends Conversor
implements NIF21Format,
NIF,
ContextJSONLD {
    private NIFFormat[] elements;
    private List<NIFBean> beans;
    private NIFParser parser;

    public NIF21() {
    }

    public NIF21(List<NIFBean> beans) {
        this.elements = new NIFFormat[]{new NIF21Resource(), new NIF21Prefixes(), new NIF21Properties(), new NIF21Literal(), new NIF21AnnotationUnit()};
        this.beans = beans;
    }

    public NIF21(List<NIFBean> beans, NIFParser parser) {
        this(beans);
        this.parser = parser;
    }

    @Override
    public Model getModel() {
        NIFBean.validate(this.beans);
        NIFBean.fillBeansWithContext(this.beans, "%s#offset_%d_%d");
        NIF21Model model = new NIF21Model();
        NIFBean bean = this.beans.get(0);
        NIF21CreateContext nif21Context = new NIF21CreateContext(bean.getContext(), bean);
        nif21Context.setModel(model.create());
        NIF21CreateContext nifVisitor = nif21Context;
        if (this.parser != null) {
            this.parser.merge(nifVisitor.getModel());
        }
        this.accept(nifVisitor);
        for (int i = 1; i < this.beans.size(); ++i) {
            nif21Context.setBean(this.beans.get(i));
            this.accept(nifVisitor);
        }
        return nifVisitor.getModel();
    }

    @Override
    public String getNTriples() {
        return super.getNTriples(this.getModel());
    }

    @Override
    public String getRDFxml() {
        return super.getRDFxml(this.getModel());
    }

    @Override
    public String getTurtle() {
        return super.getTurtle(this.getModel());
    }

    @Override
    public String getJSONLD(String context) {
        Objects.requireNonNull(context, String.format("NIF 1000 - Null is not accepted for %s", "context"));
        super.getNTriples(this.getModel());
        return super.getJSONLD(context, this.beans, TEMPLATE_NIF_PATH);
    }

    @Override
    public String getContextForJSONLD(Set<String> ontologies, String language) {
        return super.getContextForJSONLD(ontologies, TEMPLATE_CONTEXT_PATH, language);
    }

    @Override
    public String getContextForJSONLD(Set<String> ontologies, String template, String language) {
        return super.getContextForJSONLD(ontologies, template, language);
    }

    @Override
    public void accept(NIFVisitor visitor) {
        for (NIFFormat elem : this.elements) {
            elem.accept(visitor);
        }
    }

    @Override
    public String getTurtle(Model model) {
        return super.getTurtle(this.getModel());
    }
}

