/*
 * Decompiled with CFR 0.152.
 */
package org.nlp2rdf.nif21.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import org.nlp2rdf.NIFProperties;
import org.nlp2rdf.NIFVisitor;
import org.nlp2rdf.bean.NIFBean;
import org.nlp2rdf.bean.NIFContext;
import org.nlp2rdf.nif21.NIF21Format;

public class NIF21Properties
implements NIFProperties,
NIF21Format {
    @Override
    public void add(Model model, NIFBean entity) {
        if (model != null && entity != null) {
            Resource contextRes = model.getResource(entity.getContext().getNIF21());
            if (entity.isMention().booleanValue()) {
                this.fillMention(model, entity, contextRes);
            } else if (entity.isContext().booleanValue()) {
                this.fillResourceCollection(model, entity.getContext());
                this.fillContext(model, contextRes);
            }
        }
    }

    private void fillResourceCollection(Model model, NIFContext context) {
        Resource resource = model.getResource(context.getCollection());
        resource.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_CONTEXT_COLLECTION));
        resource.addProperty(model.createProperty(NIF_PROPERTY_HAS_CONTEXT), (RDFNode)model.createResource(context.getNIF21()));
        resource.addProperty(model.createProperty("http://purl.org/dc/terms/conformsTo"), (RDFNode)model.createResource("http://persistence.uni-leipzig.org/nlp2rdf/ontologies/nif-core/2.1"));
    }

    private void fillContext(Model model, Resource contextRes) {
        contextRes.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_CONTEXT));
        contextRes.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_OFFSETBASEDSTRING));
    }

    private void fillMention(Model model, NIFBean entity, Resource contextRes) {
        contextRes.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_OFFSETBASEDSTRING));
        contextRes.addProperty(RDF.type, (RDFNode)model.createResource(NIF_PROPERTY_PHRASE));
        contextRes.addProperty(model.createProperty(NIF_PROPERTY_REFERENCE_CONTEXT), (RDFNode)model.createResource(entity.getReferenceContext()));
    }

    @Override
    public void accept(NIFVisitor visitor) {
        visitor.visit(this);
    }
}

