/*
 * Decompiled with CFR 0.152.
 */
package org.nlp2rdf.parser;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nlp2rdf.nif20.NIF20Format;
import org.nlp2rdf.parser.Document;
import org.nlp2rdf.parser.EntityMention;

public class NIFParser {
    private String nif;

    public NIFParser(String nif) {
        this.nif = nif;
    }

    public static Document getDocumentFromNIFString(String nifString) {
        Statement stm;
        ArrayList<EntityMention> list = new ArrayList<EntityMention>();
        Model model = ModelFactory.createDefaultModel();
        model.read((InputStream)new ByteArrayInputStream(nifString.getBytes()), null, "TTL");
        StmtIterator iter = model.listStatements(null, RDF.type, (RDFNode)model.getResource(NIF20Format.NIF_PROPERTY_PHRASE));
        while (iter.hasNext()) {
            stm = iter.nextStatement();
            Resource entityRes = stm.getSubject().asResource();
            String mention = entityRes.getProperty(model.getProperty(NIF20Format.NIF_PROPERTY_ANCHOR_OF)).getObject().asLiteral().getString();
            String referenceContext = entityRes.getProperty(model.getProperty(NIF20Format.NIF_PROPERTY_REFERENCE_CONTEXT)).getObject().toString();
            int beginIndex = entityRes.getProperty(model.getProperty(NIF20Format.NIF_PROPERTY_BEGININDEX)).getObject().asLiteral().getInt();
            int endIndex = entityRes.getProperty(model.getProperty(NIF20Format.NIF_PROPERTY_ENDINDEX)).getObject().asLiteral().getInt();
            EntityMention em = new EntityMention();
            em.setMention(mention);
            em.setBeginIndex(beginIndex);
            em.setEndIndex(endIndex);
            em.setContext(stm.getSubject().getNameSpace());
            em.setReferenceContext(referenceContext);
            list.add(em);
        }
        iter = model.listStatements(null, RDF.type, (RDFNode)model.getResource(NIF20Format.NIF_PROPERTY_CONTEXT));
        stm = iter.nextStatement();
        Resource contextRes = stm.getSubject().asResource();
        String text = contextRes.getProperty(model.getProperty(NIF20Format.NIF_PROPERTY_ISSTRING)).getObject().asLiteral().getString();
        return new Document(list, text);
    }

    private Model init() {
        Model model = ModelFactory.createDefaultModel();
        model.read((InputStream)new ByteArrayInputStream(this.nif.getBytes()), null, "TTL");
        return model;
    }

    public Map<String, String> getPrefixes() {
        Model model = this.init();
        Map<String, String> result = new HashMap<String, String>();
        if (model != null) {
            result = model.getNsPrefixMap();
        }
        return result;
    }

    private List<Statement> getStatements() {
        Model model = this.init();
        ArrayList<Statement> result = new ArrayList<Statement>();
        StmtIterator iter = model.listStatements();
        while (iter.hasNext()) {
            Statement statement = iter.nextStatement();
            result.add(statement);
        }
        return result;
    }

    private void mergePrefixes(Model model) {
        Map<String, String> map;
        if (model != null && (map = this.getPrefixes()) != null) {
            for (String key : map.keySet()) {
                model.setNsPrefix(key, map.get(key));
            }
        }
    }

    private void mergeStatements(Model model) {
        if (model != null) {
            model.add(this.getStatements());
        }
    }

    public Model merge(Model model) {
        this.mergePrefixes(model);
        this.mergeStatements(model);
        return model;
    }
}

