/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.tire;

import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.WordAlert;

public class SmartGetWord<T> {
    private static final String EMPTYSTRING = "";
    public int offe;
    byte status = 0;
    int root;
    int i = this.root = 0;
    boolean isBack = false;
    private SmartForest<T> forest;
    private char[] chars;
    private String str;
    private int tempOffe;
    private T param;
    private SmartForest<T> branch;
    private Integer tempJLen = null;

    public SmartGetWord(SmartForest<T> forest, String content) {
        this.chars = content.toCharArray();
        this.forest = forest;
        this.branch = forest;
    }

    public SmartGetWord(SmartForest<T> forest, char[] chars) {
        this.chars = chars;
        this.forest = forest;
        this.branch = forest;
    }

    public String getAllWords() {
        String temp = this.allWords();
        temp = this.checkNumberOrEnglish(temp);
        while (EMPTYSTRING.equals(temp)) {
            temp = this.allWords();
            temp = this.checkNumberOrEnglish(temp);
        }
        return temp;
    }

    private String checkNumberOrEnglish(String temp) {
        if (temp == null || temp == EMPTYSTRING) {
            return temp;
        }
        char l = temp.charAt(0);
        if (l < '\u007f' && this.offe > 0 && this.checkSame(l, this.chars[this.offe - 1])) {
            return EMPTYSTRING;
        }
        char r = l;
        if (temp.length() > 1) {
            r = temp.charAt(temp.length() - 1);
        }
        if (r < '\u007f' && this.offe + temp.length() < this.chars.length && this.checkSame(r, this.chars[this.offe + temp.length()])) {
            return EMPTYSTRING;
        }
        return temp;
    }

    private boolean checkSame(char l, char c) {
        if (WordAlert.isEnglish(l) && WordAlert.isEnglish(c)) {
            return true;
        }
        return WordAlert.isNumber(l) && WordAlert.isNumber(c);
    }

    public String getFrontWords() {
        String temp = null;
        do {
            temp = this.frontWords();
        } while (EMPTYSTRING.equals(temp = this.checkNumberOrEnglish(temp)));
        return temp;
    }

    private String allWords() {
        while (this.i < this.chars.length) {
            if (this.tempJLen == null) {
                this.branch = this.branch.getBranch(this.chars[this.i]);
            }
            if (this.branch == null) {
                this.branch = this.forest;
                ++this.i;
                continue;
            }
            for (int j = this.i + (this.tempJLen == null ? 0 : this.tempJLen); j < this.chars.length; ++j) {
                if (j > this.i) {
                    this.branch = this.branch.getBranch(this.chars[j]);
                }
                if (this.branch == null) {
                    this.branch = this.forest;
                    ++this.i;
                    this.tempJLen = null;
                    return EMPTYSTRING;
                }
                switch (this.branch.getStatus()) {
                    case 2: {
                        this.offe = this.i;
                        this.param = this.branch.getParam();
                        this.tempJLen = j - this.i + 1;
                        return new String(this.chars, this.i, j - this.i + 1);
                    }
                    case 3: {
                        this.offe = this.i++;
                        this.param = this.branch.getParam();
                        this.branch = this.forest;
                        this.tempJLen = null;
                        return new String(this.chars, this.i - 1, j - this.i + 2);
                    }
                }
            }
            ++this.i;
            this.branch = this.forest;
            this.tempJLen = null;
            return EMPTYSTRING;
        }
        return null;
    }

    private String frontWords() {
        while (this.i < this.chars.length + 1) {
            this.branch = this.i == this.chars.length ? null : this.branch.getBranch(this.chars[this.i]);
            if (this.branch == null) {
                this.branch = this.forest;
                if (this.isBack) {
                    this.offe = this.root;
                    this.str = new String(this.chars, this.root, this.tempOffe);
                    if (this.str.length() == 0) {
                        ++this.root;
                        this.i = this.root;
                    } else {
                        this.root = this.i = this.root + this.tempOffe;
                    }
                    this.isBack = false;
                    return this.str;
                }
                this.i = this.root++;
            } else {
                switch (this.branch.getStatus()) {
                    case 2: {
                        this.isBack = true;
                        this.tempOffe = this.i - this.root + 1;
                        this.param = this.branch.getParam();
                        break;
                    }
                    case 3: {
                        this.offe = this.root;
                        String temp = this.str = new String(this.chars, this.root, this.i - this.root + 1);
                        this.param = this.branch.getParam();
                        this.branch = this.forest;
                        this.isBack = false;
                        if (temp.length() > 0) {
                            ++this.i;
                            this.root = this.i;
                        } else {
                            this.i = this.root + 1;
                        }
                        return this.str;
                    }
                }
            }
            ++this.i;
        }
        this.tempOffe += this.chars.length;
        return null;
    }

    public void reset(String content) {
        this.offe = 0;
        this.status = 0;
        this.i = this.root = 0;
        this.isBack = false;
        this.tempOffe = 0;
        this.chars = content.toCharArray();
        this.branch = this.forest;
    }

    public T getParam() {
        return this.param;
    }
}

