/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.eval;

public class PrecisionRecall {
    private final double precision;
    private final double recall;

    public PrecisionRecall(double precision, double recall) {
        this.precision = precision;
        this.recall = recall;
    }

    public double getPrecision() {
        return this.precision;
    }

    public double getRecall() {
        return this.recall;
    }

    public double getF1Score() {
        return this.getFScore(1.0);
    }

    public double getFScore(double beta) {
        double beta2 = Math.pow(beta, 2.0);
        double denominator = beta2 * this.precision + this.recall;
        if (denominator == 0.0) {
            return 0.0;
        }
        return (1.0 + beta2) * this.precision * this.recall / denominator;
    }
}

