/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.nlpub.watset.graph.Clustering;

public class MarkovClusteringBinaryRunner<V, E>
implements Clustering<V> {
    private static final Logger logger = Logger.getLogger(MarkovClusteringBinaryRunner.class.getSimpleName());
    private final Graph<V, E> graph;
    private final Path mcl;
    private final double r;
    private final int threads;
    private Map<V, Integer> mapping;
    private File output;

    public static <V, E> Function<Graph<V, E>, Clustering<V>> provider(Path mcl, double r, int threads) {
        return graph -> new MarkovClusteringBinaryRunner(graph, mcl, r, threads);
    }

    public static <V, E> Function<Graph<V, E>, Clustering<V>> provider(Path mcl, double r) {
        return graph -> new MarkovClusteringBinaryRunner(graph, mcl, r);
    }

    public MarkovClusteringBinaryRunner(Graph<V, E> graph, Path mcl, double r, int threads) {
        this.graph = Objects.requireNonNull(graph);
        this.mcl = mcl;
        this.r = r;
        this.threads = threads;
    }

    public MarkovClusteringBinaryRunner(Graph<V, E> graph, Path mcl, double r) {
        this(graph, mcl, r, 1);
    }

    @Override
    public Collection<Collection<V>> getClusters() {
        Objects.requireNonNull(this.mapping, "call fit() first");
        Objects.requireNonNull(this.output, "call fit() first");
        Map<Integer, Object> inverse = this.mapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        try {
            return Files.lines(this.output.toPath()).map(line -> Arrays.stream(line.split("\t")).map(id -> inverse.get(Integer.valueOf(id))).collect(Collectors.toSet())).collect(Collectors.toSet());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Clusters cannot be read.", ex);
        }
    }

    @Override
    public void fit() {
        logger.info("Preparing for Markov Clustering.");
        this.mapping = this.translate(this.graph);
        try {
            this.process();
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        logger.info("Markov Clustering finished.");
    }

    private void process() throws IOException, InterruptedException {
        this.output = File.createTempFile("mcl", "output");
        this.output.deleteOnExit();
        File input = this.writeInputFile();
        ProcessBuilder builder = new ProcessBuilder(this.mcl.toAbsolutePath().toString(), input.toString(), "-I", Double.toString(this.r), "-te", Integer.toString(this.threads), "--abc", "-o", this.output.toString());
        logger.info("Command: " + String.join((CharSequence)" ", builder.command()));
        Process process = builder.start();
        int status = process.waitFor();
        if (status != 0) {
            InputStreamReader isr = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                try {
                    BufferedReader reader = new BufferedReader(isr);
                    Throwable throwable2 = null;
                    try {
                        try {
                            String stderr = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                            if (stderr.isEmpty()) {
                                throw new IllegalStateException(this.mcl.toAbsolutePath() + " returned " + status);
                            }
                            throw new IllegalStateException(this.mcl.toAbsolutePath() + " returned " + status + ": " + stderr);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (reader != null) {
                            if (throwable2 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
            }
            catch (Throwable throwable7) {
                if (isr != null) {
                    if (throwable != null) {
                        try {
                            ((Reader)isr).close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        ((Reader)isr).close();
                    }
                }
                throw throwable7;
            }
        }
    }

    private Map<V, Integer> translate(Graph<V, E> graph) {
        HashMap mapping = new HashMap(graph.vertexSet().size());
        int i = 0;
        for (Object node : graph.vertexSet()) {
            mapping.put(node, i++);
        }
        return mapping;
    }

    private File writeInputFile() throws IOException {
        File input = File.createTempFile("mcl", "input");
        input.deleteOnExit();
        try (BufferedWriter writer = Files.newBufferedWriter(input.toPath(), new OpenOption[0]);){
            for (Object edge : this.graph.edgeSet()) {
                int source = this.mapping.get(this.graph.getEdgeSource(edge));
                int target = this.mapping.get(this.graph.getEdgeTarget(edge));
                double weight = this.graph.getEdgeWeight(edge);
                writer.write(String.format(Locale.ROOT, "%d\t%d\t%f%n", source, target, weight));
            }
        }
        return input;
    }
}

