/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.graph.AsUnmodifiableGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.graph.builder.GraphBuilder;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.SenseInduction;
import org.nlpub.watset.util.IndexedSense;
import org.nlpub.watset.util.Sense;

public class SimplifiedWatset<V, E>
implements Clustering<V> {
    private static final Logger logger = Logger.getLogger(SimplifiedWatset.class.getSimpleName());
    private final Graph<V, E> graph;
    private final SenseInduction<V, E> inducer;
    private final Function<Graph<Sense<V>, DefaultWeightedEdge>, Clustering<Sense<V>>> global;
    private Graph<Sense<V>, DefaultWeightedEdge> senseGraph;
    private Collection<Collection<Sense<V>>> senseClusters;
    private Map<V, Map<V, Integer>> inventory;
    private Map<V, List<Sense<V>>> senses;

    public static <V, E> Function<Graph<V, E>, Clustering<V>> provider(Function<Graph<V, E>, Clustering<V>> local, Function<Graph<Sense<V>, DefaultWeightedEdge>, Clustering<Sense<V>>> global) {
        return graph -> new SimplifiedWatset(graph, local, global);
    }

    public SimplifiedWatset(Graph<V, E> graph, Function<Graph<V, E>, Clustering<V>> local, Function<Graph<Sense<V>, DefaultWeightedEdge>, Clustering<Sense<V>>> global) {
        this.graph = Objects.requireNonNull(graph);
        this.inducer = new SenseInduction<V, E>(graph, Objects.requireNonNull(local));
        this.global = Objects.requireNonNull(global);
    }

    @Override
    public void fit() {
        this.senseClusters = null;
        this.inventory = new ConcurrentHashMap<V, Map<V, Integer>>(this.graph.vertexSet().size());
        this.senses = new ConcurrentHashMap<V, List<Sense<V>>>(this.graph.vertexSet().size());
        logger.info("Simplified Watset started.");
        this.graph.vertexSet().parallelStream().forEach(node -> {
            Collection<Collection<Object>> clusters = this.inducer.clusters(node);
            if (Objects.nonNull(this.inventory.put(node, new HashMap()))) {
                throw new IllegalStateException("The target node is already in the inventory");
            }
            if (Objects.nonNull(this.senses.put(node, new ArrayList(clusters.size())))) {
                throw new IllegalStateException("The target node is already in the sense index");
            }
            if (clusters.isEmpty()) {
                this.senses.get(node).add(new IndexedSense<Object>(node, 0));
            }
            int i = 0;
            for (Collection<Object> cluster : clusters) {
                this.senses.get(node).add(i, new IndexedSense<Object>(node, i));
                for (Object neighbor : cluster) {
                    this.inventory.get(node).put((Integer)neighbor, i);
                }
                ++i;
            }
        });
        int count = this.senses.values().stream().mapToInt(List::size).sum();
        logger.log(Level.INFO, "Simplified Watset: sense inventory constructed including {0} senses.", count);
        GraphBuilder builder = SimpleWeightedGraph.createBuilder(DefaultWeightedEdge.class);
        for (Map.Entry<V, Map<V, Integer>> sourceEntry : this.inventory.entrySet()) {
            if (sourceEntry.getValue().isEmpty()) {
                builder.addVertex(new IndexedSense<V>(sourceEntry.getKey(), 0));
            }
            V source = sourceEntry.getKey();
            for (V target : sourceEntry.getValue().keySet()) {
                Sense<V> sourceSense = Objects.requireNonNull(this.senses.get(source).get(this.inventory.get(source).get(target)));
                Sense<V> targetSense = Objects.requireNonNull(this.senses.get(target).get(this.inventory.get(target).get(source)));
                Object edge = Objects.requireNonNull(this.graph.getEdge(source, target));
                double weight = this.graph.getEdgeWeight(edge);
                builder.addEdge(sourceSense, targetSense, weight);
            }
        }
        this.senseGraph = builder.build();
        if (this.graph.edgeSet().size() != this.senseGraph.edgeSet().size()) {
            throw new IllegalStateException("Mismatch in number of edges: expected " + this.graph.edgeSet().size() + ", but got " + this.senseGraph.edgeSet().size());
        }
        logger.info("Simplified Watset: sense graph constructed.");
        Clustering<Sense<V>> globalClustering = this.global.apply(this.senseGraph);
        globalClustering.fit();
        logger.info("Simplified Watset: extracting sense clusters.");
        this.senseClusters = globalClustering.getClusters();
        logger.info("Simplified Watset finished.");
    }

    @Override
    public Collection<Collection<V>> getClusters() {
        return Objects.requireNonNull(this.senseClusters, "call fit() first").stream().map(cluster -> cluster.stream().map(Supplier::get).collect(Collectors.toSet())).collect(Collectors.toSet());
    }

    public Graph<Sense<V>, DefaultWeightedEdge> getSenseGraph() {
        return new AsUnmodifiableGraph(Objects.requireNonNull(this.senseGraph, "call fit() first"));
    }

    public Map<Sense<V>, Map<Sense<V>, Number>> getContexts() {
        HashMap contexts = new HashMap();
        for (DefaultWeightedEdge edge : Objects.requireNonNull(this.senseGraph, "call fit() first").edgeSet()) {
            Sense source = (Sense)this.senseGraph.getEdgeSource((Object)edge);
            Sense target = (Sense)this.senseGraph.getEdgeTarget((Object)edge);
            double weight = this.senseGraph.getEdgeWeight((Object)edge);
            if (!contexts.containsKey(source)) {
                contexts.put(source, new HashMap());
            }
            if (!contexts.containsKey(target)) {
                contexts.put(target, new HashMap());
            }
            ((Map)contexts.get(source)).put(target, weight);
            ((Map)contexts.get(target)).put(source, weight);
        }
        if (contexts.size() != this.senseGraph.vertexSet().size()) {
            throw new IllegalStateException("Mismatch in number of senses: expected " + this.senseGraph.vertexSet().size() + ", but got " + contexts.size());
        }
        return contexts;
    }
}

