/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.nlpub.watset.graph.Clustering;

public class SingletonClustering<V, E>
implements Clustering<V> {
    private final Graph<V, E> graph;
    private Collection<Collection<V>> clusters;

    public SingletonClustering(Graph<V, E> graph) {
        this.graph = Objects.requireNonNull(graph);
    }

    @Override
    public void fit() {
        this.clusters = this.graph.vertexSet().stream().map(Collections::singleton).collect(Collectors.toList());
    }

    @Override
    public Collection<Collection<V>> getClusters() {
        return Objects.requireNonNull(this.clusters, "call fit() first");
    }
}

