/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.nlpub.watset.util.ContextSimilarity;
import org.nlpub.watset.util.Maximizer;

public interface Sense<V>
extends Supplier<V> {
    public static <V> Map<Sense<V>, Number> disambiguate(Map<V, Map<Sense<V>, Map<V, Number>>> inventory, ContextSimilarity<V> similarity, Map<V, Number> context, Collection<V> ignored) {
        HashMap<Sense<Number>, Number> dcontext = new HashMap<Sense<Number>, Number>(context.size());
        for (Map.Entry<V, Number> entry : context.entrySet()) {
            Object target = entry.getKey();
            if (ignored.contains(target)) continue;
            Sense sense = Maximizer.argmax(inventory.getOrDefault(target, Collections.emptyMap()).keySet().iterator(), candidate -> {
                Map candidateContext = (Map)((Map)inventory.get(target)).get(candidate);
                return ((Number)similarity.apply(context, candidateContext)).doubleValue();
            }).orElseThrow(() -> new IllegalArgumentException("Cannot find the sense for the word in context."));
            dcontext.put(sense, entry.getValue());
        }
        return dcontext;
    }
}

