/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TreeMap;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ClassloaderBase;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.report.AbstractFormattedReporter;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportBuilder;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportFlattenBuilder;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportFormatter;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportHandle;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportTextFormatter;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportTreeBuilder;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportUtil;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportXMLFormatter;
import org.apache.tools.ant.taskdefs.classloader.report.FormattedAntLoggerReporter;
import org.apache.tools.ant.taskdefs.classloader.report.FormattedPrintStreamReporter;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class ClassloaderReport
extends ClassloaderBase
implements ClassloaderContext.Report {
    private Format format = null;
    private Hierarchy hierarchy = null;
    private boolean reportPackages = true;
    private File output = null;

    public ClassloaderReport() {
        this.setFailonerror(false);
    }

    public void execute() {
        AbstractFormattedReporter destReporter;
        HashMap handlesByLoader = new HashMap();
        TreeMap loaderByHandle = new TreeMap();
        if (this.format == null) {
            Format format = this.format = this.output == null ? new Format("txt") : new Format("xml");
        }
        if (this.hierarchy == null) {
            this.hierarchy = this.format.getDefaultHierarchy();
        }
        ClassloaderReportBuilder to = this.hierarchy.newBuilder(this);
        boolean addSuccess = true;
        ClassLoader extCl = ClassLoader.getSystemClassLoader().getParent();
        ClassloaderReportUtil reportUtil = ClassloaderReportUtil.getReportUtil();
        if (extCl != null && extCl.getClass().getName().equals("sun.misc.Launcher$ExtClassLoader") && !reportUtil.addLoaderToReport(this, extCl, ClassloaderReportHandle.EXTENSIONHANDLE, handlesByLoader, loaderByHandle, to)) {
            addSuccess = false;
        }
        if (!reportUtil.addLoaderToReport(this, ClassLoader.getSystemClassLoader(), ClassloaderReportHandle.SYSTEMHANDLE, handlesByLoader, loaderByHandle, to)) {
            addSuccess = false;
        }
        if (!reportUtil.addLoaderToReport(this, this.getProject().getClass().getClassLoader(), ClassloaderReportHandle.PROJECTHANDLE, handlesByLoader, loaderByHandle, to)) {
            addSuccess = false;
        }
        if (!reportUtil.addLoaderToReport(this, this.getClass().getClassLoader(), ClassloaderReportHandle.CURRENTHANDLE, handlesByLoader, loaderByHandle, to)) {
            addSuccess = false;
        }
        if (!reportUtil.addLoaderToReport(this, Thread.currentThread().getContextClassLoader(), ClassloaderReportHandle.THREADHANDLE, handlesByLoader, loaderByHandle, to)) {
            addSuccess = false;
        }
        if (!reportUtil.addLoaderToReport(this, this.getProject().getCoreLoader(), ClassloaderReportHandle.COREHANDLE, handlesByLoader, loaderByHandle, to)) {
            addSuccess = false;
        }
        Object[] rNames = this.getProject().getReferences().keySet().toArray(new String[this.getProject().getReferences().size()]);
        Arrays.sort(rNames);
        for (int i = 0; i < rNames.length; ++i) {
            Object val = this.getProject().getReference((String)rNames[i]);
            if (!(val instanceof ClassLoader) || reportUtil.addLoaderToReport(this, (ClassLoader)val, new ClassloaderReportHandle(7, (String)rNames[i]), handlesByLoader, loaderByHandle, to)) continue;
            addSuccess = false;
        }
        ComponentHelper ch = ComponentHelper.getComponentHelper((Project)this.getProject());
        Hashtable types = ch.getAntTypeTable();
        rNames = types.keySet().toArray(new String[types.size()]);
        Arrays.sort(rNames);
        for (int i = 0; i < rNames.length; ++i) {
            AntTypeDefinition val = ch.getDefinition((String)rNames[i]);
            if (val.getClassLoader() == null || reportUtil.addLoaderToReport(this, val.getClassLoader(), new ClassloaderReportHandle(8, (String)rNames[i]), handlesByLoader, loaderByHandle, to)) continue;
            addSuccess = false;
        }
        rNames = null;
        reportUtil.report((ClassloaderContext.Report)this, handlesByLoader, loaderByHandle, to, addSuccess);
        PrintStream printStream = null;
        if (this.output != null) {
            try {
                printStream = new PrintStream(new FileOutputStream(this.output));
                destReporter = new FormattedPrintStreamReporter(this.format.newFormatter(), printStream);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        } else {
            destReporter = new FormattedAntLoggerReporter(this, this.format.newFormatter());
        }
        to.execute(destReporter);
        if (printStream != null) {
            printStream.close();
        }
    }

    public boolean isReportPackages() {
        return this.reportPackages;
    }

    public void setDestfile(File file) {
        this.output = file;
    }

    public void setFormat(Format f) {
        this.format = f;
    }

    public void setHierarchy(Hierarchy h) {
        this.hierarchy = h;
    }

    public void setReportpackages(boolean onOff) {
        this.reportPackages = onOff;
    }

    public static class Hierarchy
    extends EnumeratedAttribute {
        private static final int FLAT = 0;
        private static final int TREE = 1;

        public Hierarchy() {
        }

        public Hierarchy(String value) {
            this.setValue(value);
        }

        public ClassloaderReportBuilder newBuilder(ClassloaderContext.Report context) {
            switch (this.getIndex()) {
                case 0: {
                    return new ClassloaderReportFlattenBuilder(context);
                }
                case 1: {
                    return new ClassloaderReportTreeBuilder(context);
                }
            }
            return null;
        }

        public String[] getValues() {
            return new String[]{"flat", "tree"};
        }
    }

    public static class Format
    extends EnumeratedAttribute {
        private static final int XML = 0;
        private static final int TXT = 1;

        public Format() {
        }

        public Format(String value) {
            this.setValue(value);
        }

        public ClassloaderReportFormatter newFormatter() {
            switch (this.getIndex()) {
                case 0: {
                    return new ClassloaderReportXMLFormatter();
                }
                case 1: {
                    return new ClassloaderReportTextFormatter();
                }
            }
            return null;
        }

        public Hierarchy getDefaultHierarchy() {
            switch (this.getIndex()) {
                case 0: {
                    return new Hierarchy("tree");
                }
                case 1: {
                    return new Hierarchy("flat");
                }
            }
            return null;
        }

        public String[] getValues() {
            return new String[]{"xml", "txt"};
        }
    }
}

