/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ClassloaderBase;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapter;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandler;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderParameters;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderAdapterException;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.types.AntLoaderParameters;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.LoaderHandler;
import org.apache.tools.ant.types.LoaderHandlerSet;
import org.apache.tools.ant.types.LoaderParameters;
import org.apache.tools.ant.types.LoaderRef;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.URLPath;

public class ClassloaderTask
extends ClassloaderBase
implements ClassloaderContext.CreateModify {
    private URLPath classpath = null;
    private DuplicateEntry duplicateEntry = new DuplicateEntry("omit");
    private ClassLoaderHandler handler = null;
    private LoaderRef loader = null;
    private String loaderName = null;
    private ClassLoaderParameters parameters = null;
    private LoaderRef parentLoader = null;
    private String property = null;
    private boolean reset = false;
    private LoaderRef superLoader = null;

    public void addAntParameters(AntLoaderParameters desc) {
        this.parameters = desc;
    }

    public void addConfiguredHandler(LoaderHandler handler) {
        handler.check();
        if (this.handler != null) {
            throw new BuildException("nested element handler can only specified once");
        }
        this.handler = handler;
    }

    public void addLoader(LoaderRef loader) {
        if (loader.isStandardLoader(3)) {
            throw new BuildException("nested element loader can not be 'none'");
        }
        this.loader = loader;
    }

    public void addParameters(LoaderParameters desc) {
        this.parameters = desc;
    }

    public void addParentLoader(LoaderRef loader) {
        this.parentLoader = loader;
    }

    public void addSuperLoader(LoaderRef loader) {
        this.superLoader = loader;
    }

    public URLPath createClasspath() {
        if (this.classpath == null) {
            this.classpath = new URLPath(this.getProject());
        }
        return this.classpath.createUrlpath();
    }

    public void execute() {
        if (this.loader == null) {
            throw new BuildException("no loader specified");
        }
        if (!this.executeCreateModify()) {
            return;
        }
        if (this.property != null) {
            this.executeProperty();
        }
    }

    private boolean executeCreateModify() {
        boolean modify;
        URLPath classPath = this.getClasspath();
        ClassLoader classloader = null;
        if (!this.reset) {
            classloader = this.loader.getClassLoader(null, false, true);
        }
        boolean create = classloader == null;
        boolean bl = modify = classloader != null && classPath != null;
        if (!create && !modify) {
            return true;
        }
        if ("only".equals(this.getProject().getProperty("build.sysclasspath")) && this.loader.equalsSysLoader()) {
            this.log("Changing " + this.loader.getName() + " is disabled by build.sysclasspath=only", 1);
            return true;
        }
        if (this.reset && !this.loader.isResetPossible()) {
            this.handleError("reseting " + this.loader.getName() + " is not possible");
            return false;
        }
        if (create && !this.loader.isResetPossible()) {
            this.handleError("creating " + this.loader.getName() + " is not possible");
            return false;
        }
        this.log("handling " + this.getLoaderName() + ": " + (classloader == null ? "not " : "") + "found, cp=" + this.getClasspath(), 4);
        if (classloader == null) {
            ClassLoaderHandler handler = this.getHandler();
            if (handler == null) {
                throw new BuildException("internal error: handler is null");
            }
            ClassLoaderAdapter adapter = handler.getAdapter(this);
            if (adapter == null) {
                return false;
            }
            classloader = adapter.createClassLoader(this);
            if (classloader == null) {
                return false;
            }
            this.loader.setClassLoader(classloader);
        } else if (classPath != null) {
            ClassLoaderAdapter adapter;
            try {
                adapter = this.getUtil().findAdapter(this, classloader, ClassLoaderAdapterAction.APPEND);
            }
            catch (ClassloaderAdapterException e) {
                switch (e.getReason()) {
                    case 1: {
                        this.log("NO HANDLER", 4);
                        return false;
                    }
                    case 2: {
                        this.log("NO ADAPTER", 4);
                        return false;
                    }
                }
                throw new BuildException("unexpected reason " + e.getReason(), (Throwable)e);
            }
            if (!adapter.appendClasspath(this, classloader)) {
                this.log("NO APPEND", 4);
                return false;
            }
        }
        return true;
    }

    private boolean executeProperty() {
        ClassLoaderAdapter adapter;
        ClassLoader cl = this.loader.getClassLoader(null);
        try {
            adapter = this.getUtil().findAdapter(this, cl, ClassLoaderAdapterAction.GETPATH);
        }
        catch (ClassloaderAdapterException e) {
            return false;
        }
        String[] propPath = adapter.getClasspath(this, cl, true);
        if (propPath == null) {
            return false;
        }
        StringBuffer propValue = new StringBuffer();
        if (propPath.length > 0) {
            propValue.append(propPath[0]);
        }
        for (int i = 1; i < propPath.length; ++i) {
            propValue.append(';').append(propPath[i]);
        }
        this.getProject().setProperty(this.property, propValue.toString());
        return true;
    }

    public Object getAntProject() {
        return this.getProject();
    }

    public URLPath getClasspath() {
        return this.classpath;
    }

    public String[] getClasspathFiles() {
        return this.classpath.toPath().list();
    }

    public String[] getClasspathURLs() {
        return this.classpath.list();
    }

    public ClassLoaderHandler getHandler() {
        if (this.handler == null) {
            this.handler = this.getParameters().getDefaultHandler();
        }
        return this.handler;
    }

    public String getLoaderName() {
        if (this.loaderName == null) {
            this.loaderName = this.loader.getName();
        }
        return this.loaderName;
    }

    public ClassLoaderParameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new AntLoaderParameters(this.getProject());
        }
        return this.parameters;
    }

    public ClassLoader getParentLoader() {
        if (this.parentLoader == null) {
            this.parentLoader = new LoaderRef(this.getProject(), "CORE");
            return null;
        }
        return this.parentLoader.getClassLoaderOrFallback(null, this.isFailOnError(), false);
    }

    public ClassLoader getSuperLoader() {
        if (this.superLoader == null) {
            return this.getClass().getClassLoader();
        }
        return this.superLoader.getClassLoaderOrFallback(null, this.isFailOnError(), false);
    }

    public boolean handleClasspathEntry(ClassLoader cl, String entryUrl) {
        if (!this.duplicateEntry.requiresCheck()) {
            return true;
        }
        if (!this.getUtil().containsEntry(this, cl, entryUrl)) {
            return true;
        }
        int logLevel = this.duplicateEntry.getDuplicateLogLevel();
        if (logLevel >= 0) {
            this.log("duplicate classpath entry: " + entryUrl, logLevel);
        }
        return !this.duplicateEntry.isOmitDuplicate();
    }

    protected LoaderHandlerSet newHandlerSet() {
        LoaderHandlerSet result = new LoaderHandlerSet(this.getProject());
        result.addConfiguredHandler(this.getHandler());
        return result;
    }

    public void setClasspath(URLPath classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference pathRef) {
        this.createClasspath().addReference(pathRef);
    }

    public void setHandler(LoaderHandler handler) {
        handler.check();
        this.handler = handler;
    }

    public void setLoader(LoaderRef loader) {
        if (loader.isStandardLoader(3)) {
            throw new BuildException("attribute loader can not be 'none'");
        }
        this.loader = loader;
    }

    public void setParameters(LoaderParameters desc) {
        this.parameters = desc;
    }

    public void setParentLoader(LoaderRef loader) {
        this.parentLoader = loader;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setReset(boolean onOff) {
        this.reset = onOff;
    }

    public void setSuperLoader(LoaderRef loader) {
        this.parentLoader = loader;
    }

    public static class DuplicateEntry
    extends EnumeratedAttribute {
        private static final int IGNORE = 0;
        private static final int WARN = 1;
        private static final int OMIT = 2;

        public DuplicateEntry() {
        }

        public DuplicateEntry(String value) {
            this.setValue(value);
        }

        public int getDuplicateLogLevel() {
            switch (this.getIndex()) {
                case 2: {
                    return 3;
                }
                case 1: {
                    return 1;
                }
            }
            return -1;
        }

        public String[] getValues() {
            return new String[]{"ignore", "warn", "omit"};
        }

        public boolean isOmitDuplicate() {
            return this.getIndex() != 2;
        }

        public boolean requiresCheck() {
            return this.getIndex() != 0;
        }
    }
}

