/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapter;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandler;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandlerSet;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderAdapterException;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderUtil;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReporter;

public final class SimpleClassloaderUtil
implements ClassloaderUtil {
    private static final int BUFFER_MULT = 50;
    private static final ClassloaderUtil SINGLETON = new SimpleClassloaderUtil();

    public static ClassloaderUtil getClassLoaderUtil() {
        return SINGLETON;
    }

    public boolean containsEntry(ClassloaderContext ctx, ClassLoader cl, String url) {
        ArrayList errors = new ArrayList();
        if (SimpleClassloaderUtil.containsEntryDelegatedOrSelf(ctx, cl, url, errors)) {
            return true;
        }
        if (errors.size() > 0) {
            StringBuffer sb = new StringBuffer(50 * (1 + errors.size()));
            sb.append("Check for duplicate entries fails due to the following reason(s):");
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                sb.append("\n").append(i.next());
            }
            ctx.handleWarning(sb.toString());
        }
        return false;
    }

    private static boolean containsEntryDelegatedOrSelf(ClassloaderContext ctx, ClassLoader cl, String url, List errors) {
        if (cl == null) {
            URL[] urls = ctx.getUtil().getBootstrapClasspathURLs();
            if (urls == null) {
                errors.add("bootstrap classpath not investigatable");
                return false;
            }
            for (int i = 0; i < urls.length; ++i) {
                if (!urls[i].toString().equals(url)) continue;
                return true;
            }
            return false;
        }
        if (SimpleClassloaderUtil.containsEntrySelf(ctx, cl, url, errors)) {
            return true;
        }
        ClassLoaderAdapter adapter = ctx.getUtil().findAdapter(ctx, cl, null, errors, "  parent of classloader " + cl.getClass().getModifiers(), "");
        ClassLoader parent = null;
        if (adapter != null && (parent = adapter.getParent(cl)) == null) {
            parent = adapter.getDefaultParent();
        }
        return SimpleClassloaderUtil.containsEntryDelegatedOrSelf(ctx, parent, url, errors);
    }

    private static boolean containsEntrySelf(ClassloaderContext ctx, ClassLoader cl, String url, List errors) {
        ClassLoaderAdapter adapter = ctx.getUtil().findAdapter(ctx, cl, ClassLoaderAdapterAction.GETPATH, errors, "path for classloader " + cl.getClass().getName(), "");
        if (adapter == null) {
            return false;
        }
        String[] cp = adapter.getClasspath(ctx, cl, false);
        if (cp == null) {
            errors.add("path for classloader " + cl.getClass().getName() + " not investigatable (adapter retrieves no path)");
            return false;
        }
        for (int i = 0; i < cp.length; ++i) {
            if (!cp[i].equals(url)) continue;
            return true;
        }
        return false;
    }

    public ClassLoaderAdapter findAdapter(ClassloaderContext ctx, ClassLoader cl, ClassLoaderAdapterAction action) throws ClassloaderAdapterException {
        ClassLoaderHandlerSet handlerSet = ctx.getHandlerSet();
        if (handlerSet == null) {
            throw new ClassloaderAdapterException(0);
        }
        ClassLoaderHandler handler = handlerSet.getHandler(ctx, cl, action);
        if (handler == null) {
            throw new ClassloaderAdapterException(1);
        }
        ClassLoaderAdapter adapter = handler.getAdapter(ctx);
        if (adapter == null) {
            throw new ClassloaderAdapterException(2);
        }
        return adapter;
    }

    public ClassLoaderAdapter findAdapter(ClassloaderContext ctx, ClassLoader cl, ClassLoaderAdapterAction action, ClassloaderReporter to, String errPrefix, String errSuffix) {
        try {
            return this.findAdapter(ctx, cl, action);
        }
        catch (ClassloaderAdapterException e) {
            switch (e.getReason()) {
                case 1: {
                    to.reportError(errPrefix + " not investigatable (no Loaderhandler found)" + errSuffix);
                    break;
                }
                case 2: {
                    to.reportError(errPrefix + " not investigatable (Loaderhandler retrieves no adapter)" + errSuffix);
                    break;
                }
                default: {
                    ctx.handleError(errPrefix + " not investigatable (no Loaderhandlerset)" + errSuffix, e);
                }
            }
            return null;
        }
    }

    public ClassLoaderAdapter findAdapter(ClassloaderContext ctx, ClassLoader cl, ClassLoaderAdapterAction action, List errors, String errPrefix, String errSuffix) {
        try {
            return this.findAdapter(ctx, cl, action);
        }
        catch (ClassloaderAdapterException e) {
            switch (e.getReason()) {
                case 1: {
                    errors.add(errPrefix + " not investigatable (no Loaderhandler found)" + errSuffix);
                    break;
                }
                case 2: {
                    errors.add(errPrefix + " not investigatable (Loaderhandler retrieves no adapter)" + errSuffix);
                    break;
                }
                default: {
                    ctx.handleError(errPrefix + " not investigatable (no Loaderhandlerset)" + errSuffix, e);
                }
            }
            return null;
        }
    }

    public URL[] getBootstrapClasspathURLs() {
        try {
            Object urlClassPath = Class.forName("sun.misc.Launcher").getMethod("getBootstrapClassPath", null).invoke(null, null);
            return (URL[])urlClassPath.getClass().getMethod("getURLs", null).invoke(urlClassPath, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private SimpleClassloaderUtil() {
    }
}

