/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.adapter;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderParameters;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.adapter.SimpleClassLoaderAdapter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.URLPath;

public class AntClassLoaderAdapter
extends SimpleClassLoaderAdapter {
    public boolean appendClasspath(ClassloaderContext.CreateModify task, ClassLoader classloader) {
        return this.appendClasspath(task, classloader, task.getClasspathFiles());
    }

    private boolean appendClasspath(ClassloaderContext.CreateModify task, ClassLoader classloader, String[] path) {
        try {
            Method m = classloader.getClass().getMethod("addPathElement", String.class);
            for (int i = 0; i < path.length; ++i) {
                File f = new File(path[i]);
                if (f.exists()) {
                    String sUrl = task.getURLUtil().createURL(f.getAbsolutePath()).toString();
                    if (!task.handleClasspathEntry(classloader, sUrl)) continue;
                    m.invoke((Object)classloader, f.getAbsolutePath());
                    task.handleDebug("AntClassLoader " + task.getLoaderName() + ": adding path " + f.getAbsolutePath());
                    continue;
                }
                task.handleWarning("AntClassLoader " + task.getLoaderName() + ": ignoring nonexistent path " + f.getAbsolutePath());
            }
            return true;
        }
        catch (Exception e) {
            task.handleError("can not add Path to AntClassLoader", e);
            return false;
        }
    }

    public String[] getClasspath(ClassloaderContext task, ClassLoader classloader, boolean defaultToFile) {
        try {
            String cp = (String)classloader.getClass().getMethod("getClasspath", null).invoke((Object)classloader, null);
            ArrayList<String> l = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
            while (st.hasMoreTokens()) {
                l.add(st.nextToken());
            }
            return l.toArray(new String[l.size()]);
        }
        catch (Exception e) {
            task.handleError("unable to get Classpath", e);
            return null;
        }
    }

    public ClassLoader getDefaultParent() {
        return ClassLoader.getSystemClassLoader();
    }

    protected String getDefaultParentName() {
        return "SystemClassLoader";
    }

    public ClassLoader getParent(ClassLoader classLoader) {
        try {
            ClassLoader cl = classLoader.getClass().getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            Field field = cl.loadClass(AntClassLoader.class.getName()).getDeclaredField("parent");
            field.setAccessible(true);
            return (ClassLoader)field.get(classLoader);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private boolean handleAddJavaLibraries(ClassloaderContext.CreateModify task, ClassLoader cl, String loaderId, boolean onOff) {
        if (!onOff) {
            return true;
        }
        try {
            Method m = cl.getClass().getMethod("addJavaLibraries", null);
            m.invoke((Object)cl, null);
            task.handleDebug("Loader " + loaderId + ": calling addJavaLibraries");
            return true;
        }
        catch (Exception e) {
            task.handleError("unable to call addJavaLibraries on AntClassLoader " + loaderId, e);
            return false;
        }
    }

    private boolean handleAddLoaderPackageRoot(ClassloaderContext.CreateModify task, ClassLoader cl, String loaderId, String[] pkgs) {
        if (pkgs == null) {
            return true;
        }
        try {
            Method m = cl.getClass().getMethod("addLoaderPackageRoot", String.class);
            for (int i = 0; i < pkgs.length; ++i) {
                m.invoke((Object)cl, pkgs[i]);
                task.handleDebug("Loader " + loaderId + ": calling addLoaderPackageRoot(\"" + pkgs[i] + "\")");
            }
            return true;
        }
        catch (Exception e) {
            task.handleError("unable to call addLoaderPackageRoot on AntClassLoader " + loaderId, e);
            return false;
        }
    }

    private boolean handleAddSystemPackageRoot(ClassloaderContext.CreateModify task, ClassLoader cl, String loaderId, String[] pkgs) {
        if (pkgs == null) {
            return true;
        }
        try {
            Method m = cl.getClass().getMethod("addSystemPackageRoot", String.class);
            for (int i = 0; i < pkgs.length; ++i) {
                m.invoke((Object)cl, pkgs[i]);
                task.handleDebug("Loader " + loaderId + ": calling addSystemPackageRoot(\"" + pkgs[i] + "\")");
            }
            return true;
        }
        catch (Exception e) {
            task.handleError("unable to call addSystemPackageRoot on AntClassLoader " + loaderId, e);
            return false;
        }
    }

    private ClassLoader handleCreateLoader(ClassloaderContext.CreateModify task, ClassLoader superLoader, Path path, String loaderId) {
        ClassLoader loader = null;
        try {
            loader = (ClassLoader)Class.forName("org.apache.tools.ant.loader.AntClassLoader2", true, superLoader).newInstance();
            task.handleDebug("AntClassLoader " + loaderId + " created");
            Class<?> osl = Class.forName("org.apache.tools.ant.Project", true, superLoader);
            Class<?> psl = Class.forName("org.apache.tools.ant.Project", true, task.getAntProject().getClass().getClassLoader());
            if (osl == psl) {
                loader.getClass().getMethod("setProject", osl).invoke((Object)loader, task.getAntProject());
            } else {
                task.handleWarning("can not set project for AntClassLoader " + loaderId + ": Project classes are not compatible");
            }
            if (!this.appendClasspath(task, loader, path.list())) {
                return null;
            }
            return loader;
        }
        catch (Exception e) {
            task.handleError("Unable to create AntClassLoader " + loaderId + ": " + e.getMessage(), e);
            return null;
        }
    }

    private boolean handleSetIsolated(ClassloaderContext.CreateModify task, ClassLoader cl, String loaderId, boolean onOff) {
        if (!onOff) {
            return true;
        }
        try {
            Method m = cl.getClass().getMethod("setIsolated", Boolean.TYPE);
            m.invoke((Object)cl, Boolean.TRUE);
            task.handleDebug("Loader " + loaderId + ": setting isolated=true");
            return true;
        }
        catch (Exception e) {
            task.handleError("unable to call setIsolated on AntClassLoader " + loaderId, e);
            return false;
        }
    }

    private void handleSetParent(ClassloaderContext.CreateModify task, ClassLoader cl, ClassLoader parent, String loaderId) {
        if (parent == null) {
            return;
        }
        try {
            Method m = cl.getClass().getMethod("setParent", ClassLoader.class);
            m.invoke((Object)cl, parent);
            task.handleDebug("Loader " + loaderId + ": setting parentLoader");
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private boolean handleSetParentFirst(ClassloaderContext.CreateModify task, ClassLoader cl, String loaderId, boolean onOff) {
        if (onOff) {
            return true;
        }
        try {
            Method m = cl.getClass().getMethod("setParentFirst", Boolean.TYPE);
            m.invoke((Object)cl, Boolean.FALSE);
            task.handleDebug("Loader " + loaderId + ": setting parentFirst=false");
            return true;
        }
        catch (Exception e) {
            task.handleError("unable to call setParentFirst on AntClassLoader " + loaderId, e);
            return false;
        }
    }

    protected ClassLoader initClassLoader(ClassloaderContext.CreateModify task, ClassLoader classloader) {
        ClassLoaderParameters d = task.getParameters().getParameters();
        if (d instanceof Descriptor) {
            Descriptor dd = (Descriptor)d;
            String loaderId = task.getLoaderName();
            if (!this.handleSetIsolated(task, classloader, loaderId, dd.isIsolated())) {
                return null;
            }
            if (!this.handleSetParentFirst(task, classloader, loaderId, dd.isParentFirst())) {
                return null;
            }
            if (!this.handleAddJavaLibraries(task, classloader, loaderId, dd.isAddJavaLibraries())) {
                return null;
            }
            if (!this.handleAddLoaderPackageRoot(task, classloader, loaderId, dd.getLoaderPackageRoot())) {
                return null;
            }
            if (!this.handleAddSystemPackageRoot(task, classloader, loaderId, dd.getSystemPackageRoot())) {
                return null;
            }
        }
        return super.initClassLoader(task, classloader);
    }

    public boolean isSupported(ClassLoaderAdapterAction action) {
        return true;
    }

    protected ClassLoader newClassLoader(ClassloaderContext.CreateModify task) {
        Object result;
        ClassLoader superLoader = task.getSuperLoader();
        ClassLoader parent = task.getParentLoader();
        String loaderId = task.getLoaderName();
        String[] path = task.getClasspathURLs();
        URLPath newPath = null;
        if (path != null) {
            ClassLoader explParent = parent;
            if (explParent == null) {
                explParent = this.getDefaultParent();
            }
            HashSet<String> localEntries = new HashSet<String>();
            newPath = new URLPath((Project)task.getAntProject());
            for (int i = 0; i < path.length; ++i) {
                try {
                    URL url = task.getURLUtil().createURL(path[i]);
                    String sUrl = url.toString();
                    if (!localEntries.add(sUrl) || !task.handleClasspathEntry(explParent, sUrl)) continue;
                    newPath.addURLPath(new URLPath(newPath.getProject(), sUrl));
                    continue;
                }
                catch (MalformedURLException e) {
                    task.handleError("createURL(\"" + path[i] + "\")", e);
                }
            }
        }
        if (superLoader == null) {
            result = ((Project)task.getAntProject()).createClassLoader(newPath == null ? null : newPath.toPath());
        } else {
            result = this.handleCreateLoader(task, superLoader, newPath == null ? null : newPath.toPath(), loaderId);
            if (result == null) {
                return null;
            }
        }
        this.handleSetParent(task, (ClassLoader)result, parent, loaderId);
        return result;
    }

    public static interface Descriptor
    extends ClassLoaderParameters {
        public String[] getLoaderPackageRoot();

        public String[] getSystemPackageRoot();

        public boolean isAddJavaLibraries();

        public boolean isIsolated();

        public boolean isParentFirst();
    }
}

