/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.adapter;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapter;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderParameters;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportHandle;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReporter;

public class SimpleClassLoaderAdapter
implements ClassLoaderAdapter {
    public void addReportable(ClassloaderContext.Report task, ClassLoader classloader, ClassloaderReportHandle role, Map loaderStack, Map loaderNames) {
    }

    public boolean appendClasspath(ClassloaderContext.CreateModify task, ClassLoader classloader) {
        task.handleError("append not supported (Adapter error)");
        return false;
    }

    public final ClassLoader createClassLoader(ClassloaderContext.CreateModify task) {
        ClassLoader cl = this.newClassLoader(task);
        if (cl == null) {
            return null;
        }
        return this.initClassLoader(task, cl);
    }

    public String[] getClasspath(ClassloaderContext task, ClassLoader classloader, boolean defaultToFile) {
        task.handleError("getClasspath not supported (Adapter error)");
        return null;
    }

    public ClassLoader getDefaultParent() {
        return null;
    }

    protected String getDefaultParentName() {
        return "Bootstrap";
    }

    public Package[] getPackages(ClassloaderContext.Report task, ClassLoader cl, ClassloaderReportHandle name) {
        try {
            Method m = ClassLoader.class.getDeclaredMethod("getPackages", null);
            m.setAccessible(true);
            return (Package[])m.invoke((Object)cl, null);
        }
        catch (NoSuchMethodException e) {
            task.handleWarning("Loader " + name + ": oops, getPackages not supported (java < 1.2 ?).");
            return null;
        }
        catch (SecurityException e) {
            task.handleError("unable to setAccessible(true) for method getPackages", e);
            return null;
        }
        catch (Exception e) {
            task.handleError(e.getMessage(), e);
            return null;
        }
    }

    public ClassLoader getParent(ClassLoader classLoader) {
        return classLoader.getParent();
    }

    private boolean handleSetClassAssertionStatus(ClassloaderContext.CreateModify task, ClassLoader cl, String name, String[] classes, boolean onOff) {
        if (classes == null) {
            return true;
        }
        try {
            Method m = cl.getClass().getMethod("setClassAssertionStatus", String.class, Boolean.TYPE);
            for (int i = 0; i < classes.length; ++i) {
                m.invoke((Object)cl, classes[i], onOff ? Boolean.TRUE : Boolean.FALSE);
                task.handleDebug("Loader " + name + ": setting ClassAssertionStatus for " + classes[i] + "=" + onOff);
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            task.handleWarning("Loader " + name + ": ClassAssertionStatus not supported.");
            return true;
        }
        catch (Exception e) {
            task.handleError(e.getMessage(), e);
            return false;
        }
    }

    private boolean handleSetDefaultAssertionStatus(ClassloaderContext.CreateModify task, ClassLoader cl, String name, Boolean onOff) {
        if (onOff == null) {
            return true;
        }
        try {
            Method m = cl.getClass().getMethod("setDefaultAssertionStatus", Boolean.TYPE);
            m.invoke((Object)cl, onOff);
            task.handleDebug("Loader " + name + ": setting DefaultAssertionStatus=" + onOff);
            return true;
        }
        catch (NoSuchMethodException e) {
            task.handleWarning("Loader " + name + ": PackageAssertionStatus not supported.");
            return true;
        }
        catch (Exception e) {
            task.handleError(e.getMessage(), e);
            return false;
        }
    }

    private boolean handleSetPackageAssertionStatus(ClassloaderContext.CreateModify task, ClassLoader cl, String name, String[] pkgs, boolean onOff) {
        if (pkgs == null) {
            return true;
        }
        try {
            Method m = cl.getClass().getMethod("setPackageAssertionStatus", String.class, Boolean.TYPE);
            for (int i = 0; i < pkgs.length; ++i) {
                m.invoke((Object)cl, pkgs[i], onOff ? Boolean.TRUE : Boolean.FALSE);
                task.handleDebug("Loader " + name + ": setting PackageAssertionStatus for " + pkgs[i] + "=" + onOff);
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            task.handleWarning("Loader " + name + ": PackageAssertionStatus not supported.");
            return true;
        }
        catch (Exception e) {
            task.handleError(e.getMessage(), e);
            return false;
        }
    }

    protected ClassLoader initClassLoader(ClassloaderContext.CreateModify task, ClassLoader classloader) {
        ClassLoaderParameters d = task.getParameters().getParameters();
        if (d instanceof Descriptor) {
            Descriptor dd = (Descriptor)d;
            String loaderId = task.getLoaderName();
            if (!this.handleSetDefaultAssertionStatus(task, classloader, loaderId, dd.getDefaultAssertionStatus())) {
                return null;
            }
            if (!this.handleSetPackageAssertionStatus(task, classloader, loaderId, dd.getPackageAssertions(true), true)) {
                return null;
            }
            if (!this.handleSetPackageAssertionStatus(task, classloader, loaderId, dd.getPackageAssertions(false), false)) {
                return null;
            }
            if (!this.handleSetClassAssertionStatus(task, classloader, loaderId, dd.getClassAssertions(true), true)) {
                return null;
            }
            if (!this.handleSetClassAssertionStatus(task, classloader, loaderId, dd.getClassAssertions(false), false)) {
                return null;
            }
        }
        return classloader;
    }

    public boolean isSupported(ClassLoaderAdapterAction action) {
        if (action == null) {
            return true;
        }
        return ClassLoaderAdapterAction.REPORT.equals(action);
    }

    protected ClassLoader newClassLoader(ClassloaderContext.CreateModify task) {
        task.handleError("new ClassLoader not supported (Adapter error).");
        return null;
    }

    public void report(ClassloaderReporter to, ClassloaderContext.Report task, ClassLoader classloader, ClassloaderReportHandle role) {
    }

    public static interface Descriptor
    extends ClassLoaderParameters {
        public String[] getClassAssertions(boolean var1);

        public Boolean getDefaultAssertionStatus();

        public String[] getPackageAssertions(boolean var1);
    }
}

