/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.adapter;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.adapter.SimpleClassLoaderAdapter;

public class URLClassLoaderAdapter
extends SimpleClassLoaderAdapter {
    public boolean appendClasspath(ClassloaderContext.CreateModify task, ClassLoader classloader) {
        Method meth;
        URLClassLoader ucl = (URLClassLoader)classloader;
        String loaderId = task.getLoaderName();
        try {
            meth = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            meth.setAccessible(true);
        }
        catch (SecurityException e1) {
            task.handleError("unable to setAccessible(true) for method addURL", e1);
            return false;
        }
        catch (NoSuchMethodException e1) {
            task.handleError("method addURL not found", e1);
            return false;
        }
        HashSet<String> localEntries = new HashSet<String>();
        String[] list = task.getClasspathURLs();
        for (int i = 0; i < list.length; ++i) {
            try {
                URL url = task.getURLUtil().createURL(list[i]);
                String sUrl = url.toString();
                if (!localEntries.add(sUrl) || !task.handleClasspathEntry(ucl, sUrl)) continue;
                meth.invoke((Object)ucl, url);
                task.handleDebug("URLClassLoader " + loaderId + ": adding path " + url);
                continue;
            }
            catch (MalformedURLException e) {
                task.handleError("createURL(\"" + list[i] + "\")", e);
                continue;
            }
            catch (Exception e) {
                task.handleError("unable to invoke URLClassLoader.addURL(url)", e);
                return false;
            }
        }
        return true;
    }

    public String[] getClasspath(ClassloaderContext task, ClassLoader classloader, boolean defaultToFile) {
        URL[] urls = ((URLClassLoader)classloader).getURLs();
        String[] result = new String[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            result[i] = defaultToFile && "file".equals(urls[i].getProtocol()) ? task.getURLUtil().createFile(urls[i].toString()).toString() : urls[i].toString();
        }
        return result;
    }

    public boolean isSupported(ClassLoaderAdapterAction action) {
        return true;
    }

    protected ClassLoader newClassLoader(ClassloaderContext.CreateModify task) {
        ClassLoader parent = task.getParentLoader();
        String loaderId = task.getLoaderName();
        String[] scp = task.getClasspathURLs();
        ArrayList<URL> ucp = new ArrayList<URL>(scp.length);
        HashSet<String> localEntries = new HashSet<String>();
        for (int i = 0; i < scp.length; ++i) {
            try {
                URL url = task.getURLUtil().createURL(scp[i]);
                String sUrl = url.toString();
                if (!localEntries.add(sUrl) || !task.handleClasspathEntry(parent, sUrl)) continue;
                ucp.add(url);
                continue;
            }
            catch (Exception e) {
                task.handleError("createURL(\"" + scp[i] + "\")", e);
            }
        }
        URL[] urls = ucp.toArray(new URL[ucp.size()]);
        URLClassLoader cl = new URLClassLoader(urls, parent);
        task.handleDebug("URLClassLoader " + loaderId + " created.");
        for (int i = 0; i < urls.length; ++i) {
            task.handleDebug("URLClassLoader " + loaderId + ": adding path " + urls[i]);
        }
        if (parent != null) {
            task.handleDebug("URLClassLoader " + loaderId + ": setting parent loader " + parent);
        }
        return cl;
    }
}

