/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.report;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportBuilder;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportHandle;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReporter;

public final class ClassloaderReportFlattenBuilder
implements ClassloaderReportBuilder {
    private Map cLbyHandle = new HashMap();
    private CL currentCL;
    private ArrayList errors = new ArrayList();
    private SortedSet unassigned = new TreeSet();
    private final ClassloaderContext.Report context;

    public ClassloaderReportFlattenBuilder(ClassloaderContext.Report context) {
        this.context = context;
    }

    public void beginAttributes(int num) {
    }

    public void beginChildLoaders(int num) {
    }

    public void beginClassloader(ClassloaderReportHandle name) {
        this.currentCL = new CL(name);
        this.cLbyHandle.put(name, this.currentCL);
    }

    public void beginEntries(int num) {
    }

    public void beginErrors(int num) {
    }

    public void beginPackages(int num) {
    }

    public void beginReport() {
    }

    public void beginRoles(int num) {
    }

    public void beginUnassignedRoles(int num) {
    }

    public void endAttributes(int num) {
    }

    public void endChildLoaders(int num) {
    }

    public void endClassloader(ClassloaderReportHandle name) {
    }

    public void endEntries(int num) {
    }

    public void endErrors(int num) {
    }

    public void endPackages(int num) {
    }

    public void endReport() {
    }

    public void endRoles(int num) {
    }

    public void endUnassignedRoles(int num) {
    }

    public void execute(ClassloaderReporter to) {
        Iterator<Object> i;
        to.beginReport();
        if (this.errors.size() > 0) {
            to.beginErrors(this.errors.size());
            i = this.errors.iterator();
            while (i.hasNext()) {
                to.reportError((String)i.next());
            }
            to.endErrors(this.errors.size());
        }
        if (this.unassigned.size() > 0) {
            to.beginUnassignedRoles(this.unassigned.size());
            i = this.unassigned.iterator();
            while (i.hasNext()) {
                to.reportUnassignedRole((ClassloaderReportHandle)i.next());
            }
            to.endUnassignedRoles(this.unassigned.size());
        }
        i = this.cLbyHandle.values().iterator();
        while (i.hasNext()) {
            ((CL)i.next()).childs = new TreeSet();
        }
        TreeMap<ClassloaderReportHandle, CL> roots = new TreeMap<ClassloaderReportHandle, CL>();
        for (CL cl : this.cLbyHandle.values()) {
            roots.put(cl.handle, cl);
            if (cl.parent == null) continue;
            CL parent = (CL)this.cLbyHandle.get(cl.parent);
            if (parent == null) {
                throw new RuntimeException("internal error: " + cl.parent + " not found");
            }
            parent.childs.add(cl.handle);
        }
        Iterator i2 = roots.values().iterator();
        while (i2.hasNext()) {
            this.execute(to, (CL)i2.next());
        }
        to.endReport();
    }

    private void execute(ClassloaderReporter to, CL cl) {
        to.beginClassloader(cl.handle);
        if (cl.parent != null) {
            if (cl.expliciteParent) {
                to.reportExlicitelyParent(cl.parent);
            } else {
                to.reportImplicitelyParent(cl.parent);
            }
        }
        if (cl.clazz != null) {
            to.reportClass(cl.clazz);
        }
        if (cl.attributes != null) {
            to.beginAttributes(cl.attributes.size());
            for (CL.Attr attr : cl.attributes) {
                to.reportAttribute(attr.name, attr.value);
            }
            to.endAttributes(cl.attributes.size());
        }
        if (cl.entries != null) {
            to.beginEntries(cl.entries.size());
            for (CL.Entry e : cl.entries) {
                to.reportEntry(e.type, e.value);
            }
            to.endEntries(cl.entries.size());
        }
        if (cl.roles != null) {
            to.beginRoles(cl.roles.size());
            Iterator iR = cl.roles.iterator();
            while (iR.hasNext()) {
                to.reportRole((ClassloaderReportHandle)iR.next());
            }
            to.endRoles(cl.roles.size());
        }
        if (this.context.isReportPackages() && cl.packages != null) {
            to.beginPackages(cl.packages.size());
            Iterator iP = cl.packages.iterator();
            while (iP.hasNext()) {
                to.reportPackage((String)iP.next());
            }
            to.endPackages(cl.packages.size());
        }
        if (cl.childs.size() > 0) {
            to.beginChildLoaders(cl.childs.size());
            Iterator iC = cl.childs.iterator();
            while (iC.hasNext()) {
                to.reportChild((ClassloaderReportHandle)iC.next());
            }
            to.endChildLoaders(cl.childs.size());
        }
        to.endClassloader(cl.handle);
    }

    public void reportAttribute(String name, String value) {
        this.currentCL.attributes.add(new CL.Attr(name, value));
    }

    public void reportChild(ClassloaderReportHandle name) {
    }

    public void reportClass(Class s) {
        this.currentCL.clazz = s;
    }

    public void reportEntry(String type, String entry) {
        this.currentCL.entries.add(new CL.Entry(type, entry));
    }

    public void reportEntry(URL url) {
        this.reportEntry("url", url.toString());
    }

    public void reportError(String msg) {
        this.errors.add(msg);
    }

    public void reportExlicitelyParent(ClassloaderReportHandle handle) {
        this.currentCL.parent = handle;
        this.currentCL.expliciteParent = true;
    }

    public void reportImplicitelyParent(ClassloaderReportHandle handle) {
        this.currentCL.parent = handle;
        this.currentCL.expliciteParent = false;
    }

    public void reportPackage(String pkg) {
        this.currentCL.packages.add(pkg);
    }

    public void reportRole(ClassloaderReportHandle handle) {
        this.currentCL.roles.add(handle);
    }

    public void reportUnassignedRole(ClassloaderReportHandle handle) {
        this.unassigned.add(handle);
    }

    private static class CL {
        private ArrayList attributes = new ArrayList();
        private SortedSet childs;
        private Class clazz = null;
        private ArrayList entries = new ArrayList();
        private boolean expliciteParent;
        private final ClassloaderReportHandle handle;
        private SortedSet packages = new TreeSet();
        private ClassloaderReportHandle parent;
        private SortedSet roles = new TreeSet();

        public CL(ClassloaderReportHandle handle) {
            this.handle = handle;
        }

        private static class Entry {
            private final String type;
            private final String value;

            Entry(String type, String value) {
                this.type = type;
                this.value = value;
            }
        }

        private static class Attr {
            private final String name;
            private final String value;

            Attr(String name, String value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

