/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.report;

import java.net.URL;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportFormatter;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportHandle;

public class ClassloaderReportTextFormatter
implements ClassloaderReportFormatter {
    private static final String PREFIX_ATTRIBUTES = "  - ";
    private static final String PREFIX_CHILDS = "  - ";
    private static final String PREFIX_CLASSLOADER = "  ";
    private static final String PREFIX_ENTRIES = "  - ";
    private static final String PREFIX_ERRORS = "  - ";
    private static final String PREFIX_PACKAGES = "  - ";
    private static final String PREFIX_REPORT = "";
    private static final String PREFIX_ROLES = "  - ";
    private static final String PREFIX_UNASSIGNED_ROLES = "  - ";

    public String beginAttributes(int num, String[] prefix) {
        String result = prefix[0] + "attributes: " + num + " entries";
        this.incPrefix(prefix, "  - ");
        return result;
    }

    public String beginChildLoaders(int num, String[] prefix) {
        String result = prefix[0] + "childs:     " + num + " entries";
        this.incPrefix(prefix, "  - ");
        return result;
    }

    public String beginClassloader(ClassloaderReportHandle name, String[] prefix) {
        String result = prefix[0] + "classloader: " + this.getRole(name);
        this.incPrefix(prefix, PREFIX_CLASSLOADER);
        return result;
    }

    public String beginEntries(int num, String[] prefix) {
        String result = prefix[0] + "entries:    " + num + " entries";
        this.incPrefix(prefix, "  - ");
        return result;
    }

    public String beginErrors(int num, String[] prefix) {
        String result = prefix[0] + "errors: " + num + " entries";
        this.incPrefix(prefix, "  - ");
        return result;
    }

    public String beginPackages(int num, String[] prefix) {
        String result = prefix[0] + "packages:   " + num + " entries";
        this.incPrefix(prefix, "  - ");
        return result;
    }

    public String beginReport(String[] prefix) {
        String result = prefix[0] + "classloaderreport";
        this.incPrefix(prefix, PREFIX_REPORT);
        return result;
    }

    public String beginRoles(int num, String[] prefix) {
        String result = prefix[0] + "roles:      " + num + " entries";
        this.incPrefix(prefix, "  - ");
        return result;
    }

    public String beginUnassignedRoles(int num, String[] prefix) {
        String result = prefix[0] + "unassigned roles: " + num + " entries";
        this.incPrefix(prefix, "  - ");
        return result;
    }

    private void decPrefix(String[] prefix, String pref) {
        prefix[0] = prefix[0].substring(0, prefix[0].length() - pref.length());
    }

    public String endAttributes(int num, String[] prefix) {
        this.decPrefix(prefix, "  - ");
        return null;
    }

    public String endChildLoaders(int num, String[] prefix) {
        this.decPrefix(prefix, "  - ");
        return null;
    }

    public String endClassloader(ClassloaderReportHandle name, String[] prefix) {
        this.decPrefix(prefix, PREFIX_CLASSLOADER);
        return prefix[0] + "----- end of " + this.getRole(name);
    }

    public String endEntries(int num, String[] prefix) {
        this.decPrefix(prefix, "  - ");
        return null;
    }

    public String endErrors(int num, String[] prefix) {
        this.decPrefix(prefix, "  - ");
        return null;
    }

    public String endPackages(int num, String[] prefix) {
        this.decPrefix(prefix, "  - ");
        return null;
    }

    public String endReport(String[] prefix) {
        this.decPrefix(prefix, PREFIX_REPORT);
        return prefix[0] + "end of classloaderreport";
    }

    public String endRoles(int num, String[] prefix) {
        this.decPrefix(prefix, "  - ");
        return null;
    }

    public String endUnassignedRoles(int num, String[] prefix) {
        this.decPrefix(prefix, "  - ");
        return null;
    }

    public String formatAttribute(String name, String value, String[] prefix) {
        return prefix[0] + name + " = " + value;
    }

    public String formatChild(ClassloaderReportHandle name, String[] prefix) {
        return prefix[0] + this.getRole(name);
    }

    public String formatClass(Class cl, String[] prefix) {
        return prefix[0] + "class:      " + cl.getName();
    }

    public String formatEntry(String type, String entry, String[] prefix) {
        return prefix[0] + type + "=" + entry;
    }

    public String formatEntry(URL url, String[] prefix) {
        return this.formatEntry("url", String.valueOf(url), prefix);
    }

    public String formatError(String msg, String[] prefix) {
        return prefix[0] + msg;
    }

    public String formatExpliciteParent(ClassloaderReportHandle name, String[] prefix) {
        return prefix[0] + "parent:     " + this.getRole(name);
    }

    public String formatImpliciteParent(ClassloaderReportHandle name, String[] prefix) {
        return prefix[0] + "parent:     NULL (Default: " + this.getRole(name) + ")";
    }

    public String formatPackage(String pkg, String[] prefix) {
        return prefix[0] + pkg;
    }

    public String formatRole(ClassloaderReportHandle name, String[] prefix) {
        return prefix[0] + this.getRole(name);
    }

    public String formatUnassignedRole(ClassloaderReportHandle name, String[] prefix) {
        return prefix[0] + this.getRole(name);
    }

    private String getRole(ClassloaderReportHandle name) {
        return name.getType() + (name.getName() != null ? " " + name.getName() : PREFIX_REPORT);
    }

    private void incPrefix(String[] prefix, String inc) {
        prefix[0] = prefix[0] + inc;
    }
}

