/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.report;

import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapter;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportHandle;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReporter;

public class ClassloaderReportUtil {
    private static ClassloaderReportUtil singleton = new ClassloaderReportUtil();

    public static ClassloaderReportUtil getReportUtil() {
        return singleton;
    }

    public static void setReportUtil(ClassloaderReportUtil util) {
        if (util != null) {
            singleton = util;
        }
    }

    protected ClassloaderReportUtil() {
    }

    public boolean addLoaderToReport(ClassloaderContext.Report context, ClassLoader cl, ClassloaderReportHandle role, Map handlesByLoader, Map loaderByHandle, ClassloaderReporter to) {
        Object old = loaderByHandle.put(role, cl);
        if (old != null) {
            throw new RuntimeException("duplicate classloader " + role);
        }
        if (cl != null) {
            boolean isNew;
            old = handlesByLoader.get(cl);
            boolean bl = isNew = old == null;
            if (old == null) {
                old = new TreeSet();
                handlesByLoader.put(cl, old);
            }
            ((Set)old).add(role);
            if (isNew) {
                boolean adapterFound;
                ClassLoaderAdapter adapter = context.getUtil().findAdapter((ClassloaderContext)context, cl, null, to, role + "->parent", role.getName());
                boolean bl2 = adapterFound = adapter != null;
                if (adapterFound) {
                    ClassLoader parent = adapter.getParent(cl);
                    if (parent == null) {
                        parent = adapter.getDefaultParent();
                    }
                    if (parent != null) {
                        this.addLoaderToReport(context, adapter.getParent(cl), new ClassloaderReportHandle(9, role.toString()), handlesByLoader, loaderByHandle, to);
                    }
                }
                if ((adapter = context.getUtil().findAdapter((ClassloaderContext)context, cl, ClassLoaderAdapterAction.REPORT, to, "report for " + role, "")) != null) {
                    adapter.addReportable(context, cl, role, handlesByLoader, loaderByHandle);
                }
                return adapterFound && adapter != null;
            }
        }
        return true;
    }

    public void report(ClassloaderContext.Report context, ClassloaderReporter to, ClassLoader cl, ClassloaderReportHandle name, Map handlesByLoader) {
        to.beginClassloader(name);
        ClassLoaderAdapter baseAdapter = context.getUtil().findAdapter((ClassloaderContext)context, cl, null, to, "parent for " + name, "");
        if (baseAdapter != null) {
            SortedSet handles;
            ClassLoader parent = baseAdapter.getParent(cl);
            if (parent != null) {
                handles = (SortedSet)handlesByLoader.get(parent);
                to.reportExlicitelyParent((ClassloaderReportHandle)handles.first());
            } else {
                parent = baseAdapter.getDefaultParent();
                if (parent != null) {
                    handles = (SortedSet)handlesByLoader.get(parent);
                    to.reportImplicitelyParent((ClassloaderReportHandle)handles.first());
                } else {
                    to.reportImplicitelyParent(ClassloaderReportHandle.BOOTSTRAPHANDLE);
                }
            }
        }
        to.reportClass(cl.getClass());
        SortedSet roles = (SortedSet)handlesByLoader.get(cl);
        Iterator iRole = roles.iterator();
        while (iRole.hasNext()) {
            to.reportRole((ClassloaderReportHandle)iRole.next());
        }
        ClassLoaderAdapter adapter = context.getUtil().findAdapter((ClassloaderContext)context, cl, ClassLoaderAdapterAction.GETPATH, to, "entries for " + name, "");
        if (adapter != null) {
            String[] cp = adapter.getClasspath(context, cl, false);
            if (cp == null) {
                to.reportError("entries for " + name + " not investigatable (adapter retrieves no path)");
            } else {
                to.beginEntries(cp.length);
                for (int i = 0; i < cp.length; ++i) {
                    to.reportEntry("url", cp[i]);
                }
            }
        }
        if (context.isReportPackages()) {
            this.reportPackages(context, to, baseAdapter, cl, name);
        }
        if ((adapter = context.getUtil().findAdapter((ClassloaderContext)context, cl, ClassLoaderAdapterAction.REPORT, to, "additional parameters for " + name, "")) != null) {
            adapter.report(to, context, cl, name);
        }
    }

    public void report(ClassloaderContext.Report context, Map handlesByLoader, Map loaderByHandle, ClassloaderReporter to, boolean allHandlersFound) {
        URL[] urls;
        to.beginReport();
        if (!allHandlersFound) {
            to.reportError("WARNING: As of missing Loaderhandlers, this report might not be complete.");
        }
        if ((urls = context.getUtil().getBootstrapClasspathURLs()) == null) {
            to.reportError("WARNING: Unable to determine bootstrap classpath.\n         Please report this error to Ant's bugtracking  system with information\n         about your environment  (JVM-Vendor, JVM-Version, OS, application context).");
        } else {
            to.beginClassloader(ClassloaderReportHandle.BOOTSTRAPHANDLE);
            to.beginEntries(urls.length);
            for (int i = 0; i < urls.length; ++i) {
                to.reportEntry(urls[i]);
            }
            to.endEntries(urls.length);
            to.endClassloader(ClassloaderReportHandle.BOOTSTRAPHANDLE);
        }
        for (ClassloaderReportHandle role : loaderByHandle.keySet()) {
            ClassLoader cl = (ClassLoader)loaderByHandle.get(role);
            if (cl == null) {
                if (!role.isPopular()) continue;
                to.reportUnassignedRole(role);
                continue;
            }
            SortedSet handles = (SortedSet)handlesByLoader.get(cl);
            if (!role.equals(handles.first())) continue;
            this.report(context, to, cl, role, handlesByLoader);
        }
        to.endReport();
    }

    private void reportPackages(ClassloaderContext.Report task, ClassloaderReporter to, ClassLoaderAdapter adapter, ClassLoader classloader, ClassloaderReportHandle role) {
        Package[] pkgs = adapter.getPackages(task, classloader, role);
        if (pkgs == null) {
            to.reportError("packages of " + role + " not investigatable");
        } else {
            Arrays.sort(pkgs, PackageComparator.SINGLETON);
            to.beginPackages(pkgs.length);
            for (int i = 0; i < pkgs.length; ++i) {
                to.reportPackage(pkgs[i].getName());
            }
            to.endPackages(pkgs.length);
        }
    }

    private static final class PackageComparator
    implements Comparator {
        public static final Comparator SINGLETON = new PackageComparator();

        private PackageComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Package)o1).getName().compareTo(((Package)o2).getName());
        }
    }
}

