/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.report;

import java.net.URL;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportFormatter;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportHandle;

public class ClassloaderReportXMLFormatter
implements ClassloaderReportFormatter {
    private String tab = "  ";

    public String beginAttributes(int num, String[] prefix) {
        String result = prefix[0] + "<attributes count=\"" + num + "\">";
        this.incPrefix(prefix);
        return result;
    }

    public String beginChildLoaders(int num, String[] prefix) {
        String result = prefix[0] + "<childs count=\"" + num + "\">";
        this.incPrefix(prefix);
        return result;
    }

    public String beginClassloader(ClassloaderReportHandle name, String[] prefix) {
        String result = prefix[0] + "<classloader type=\"" + name.getType() + (name.getName() != null ? "\" name=\"" + name.getName() : "") + "\">";
        this.incPrefix(prefix);
        return result;
    }

    public String beginEntries(int num, String[] prefix) {
        String result = prefix[0] + "<entries count=\"" + num + "\">";
        this.incPrefix(prefix);
        return result;
    }

    public String beginErrors(int num, String[] prefix) {
        String result = prefix[0] + "<errors count=\"" + num + "\">";
        this.incPrefix(prefix);
        return result;
    }

    public String beginPackages(int num, String[] prefix) {
        String result = prefix[0] + "<packages count=\"" + num + "\">";
        this.incPrefix(prefix);
        return result;
    }

    public String beginReport(String[] prefix) {
        String result = prefix[0] + "<classloaderreport>";
        this.incPrefix(prefix);
        return result;
    }

    public String beginRoles(int num, String[] prefix) {
        String result = prefix[0] + "<roles count=\"" + num + "\">";
        this.incPrefix(prefix);
        return result;
    }

    public String beginUnassignedRoles(int num, String[] prefix) {
        String result = prefix[0] + "<unassigned-roles count=\"" + num + "\">";
        this.incPrefix(prefix);
        return result;
    }

    private void decPrefix(String[] prefix) {
        prefix[0] = prefix[0].substring(0, prefix[0].length() - this.tab.length());
    }

    public String endAttributes(int num, String[] prefix) {
        this.decPrefix(prefix);
        return prefix[0] + "</attributes>";
    }

    public String endChildLoaders(int num, String[] prefix) {
        this.decPrefix(prefix);
        return prefix[0] + "</childs>";
    }

    public String endClassloader(ClassloaderReportHandle name, String[] prefix) {
        this.decPrefix(prefix);
        return prefix[0] + "</classloader>";
    }

    public String endEntries(int num, String[] prefix) {
        this.decPrefix(prefix);
        return prefix[0] + "</entries>";
    }

    public String endErrors(int num, String[] prefix) {
        this.decPrefix(prefix);
        return prefix[0] + "</errors>";
    }

    public String endPackages(int num, String[] prefix) {
        this.decPrefix(prefix);
        return prefix[0] + "</packages>";
    }

    public String endReport(String[] prefix) {
        this.decPrefix(prefix);
        return prefix[0] + "</classloaderreport>";
    }

    public String endRoles(int num, String[] prefix) {
        this.decPrefix(prefix);
        return prefix[0] + "</roles>";
    }

    public String endUnassignedRoles(int num, String[] prefix) {
        this.decPrefix(prefix);
        return prefix[0] + "</unassigned-roles>";
    }

    public String formatAttribute(String name, String value, String[] prefix) {
        return prefix[0] + "<attribute name=\"" + name + "\" value=\"" + value + "\"/>";
    }

    public String formatChild(ClassloaderReportHandle name, String[] prefix) {
        return prefix[0] + "<child type=\"" + name.getType() + (name.getName() != null ? "\" name=\"" + name.getName() : "") + "\"/>";
    }

    public String formatClass(Class cl, String[] prefix) {
        return prefix[0] + "<class name=\"" + cl.getName() + "\"/>";
    }

    public String formatEntry(String type, String entry, String[] prefix) {
        return prefix[0] + "<entry " + type + "=\"" + entry + "\"/>";
    }

    public String formatEntry(URL url, String[] prefix) {
        return prefix[0] + "<entry url=\"" + url + "\"/>";
    }

    public String formatError(String msg, String[] prefix) {
        return prefix[0] + "<error msg=\"" + msg + "\"/>";
    }

    public String formatExpliciteParent(ClassloaderReportHandle name, String[] prefix) {
        return prefix[0] + "<parent definition=\"explicitely\" type=\"" + name.getType() + (name.getName() != null ? "\" name=\"" + name.getName() : "") + "\"/>";
    }

    public String formatImpliciteParent(ClassloaderReportHandle name, String[] prefix) {
        return prefix[0] + "<parent definition=\"default\" type=\"" + name.getType() + (name.getName() != null ? "\" name=\"" + name.getName() : "") + "\"/>";
    }

    public String formatPackage(String pkg, String[] prefix) {
        return prefix[0] + "<package name=\"" + pkg + "\"/>";
    }

    public String formatRole(ClassloaderReportHandle name, String[] prefix) {
        return prefix[0] + "<role type=\"" + name.getType() + (name.getName() != null ? "\" name=\"" + name.getName() : "") + "\"/>";
    }

    public String formatUnassignedRole(ClassloaderReportHandle name, String[] prefix) {
        return prefix[0] + "<role type=\"" + name.getType() + (name.getName() != null ? "\" name=\"" + name.getName() : "") + "\"/>";
    }

    private void incPrefix(String[] prefix) {
        prefix[0] = prefix[0] + this.tab;
    }
}

