/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandler;
import org.apache.tools.ant.taskdefs.classloader.adapter.AntClassLoaderAdapter;
import org.apache.tools.ant.types.LoaderParameters;
import org.apache.tools.ant.types.Reference;

public class AntLoaderParameters
extends LoaderParameters
implements AntClassLoaderAdapter.Descriptor {
    private boolean addJavaLibraries = false;
    private boolean isolated = false;
    private String[] loaderPackageRoot = null;
    private boolean parentFirst = true;
    private String[] systemPackageRoot = null;

    public AntLoaderParameters(Project project) {
        super(project);
    }

    public AntLoaderParameters(Project project, Reference refid) {
        super(project, refid);
    }

    public ClassLoaderHandler getDefaultHandler() {
        if (this.isReference()) {
            return super.getDefaultHandler();
        }
        return (ClassLoaderHandler)this.getProject().getReference("ant.clhandler.AntClassLoader");
    }

    public String[] getLoaderPackageRoot() {
        if (this.isReference()) {
            AntClassLoaderAdapter.Descriptor r = (AntClassLoaderAdapter.Descriptor)this.getCheckedRef(AntClassLoaderAdapter.Descriptor.class, "antLoaderDescriptor");
            return r.getLoaderPackageRoot();
        }
        return this.loaderPackageRoot;
    }

    public String[] getSystemPackageRoot() {
        if (this.isReference()) {
            AntClassLoaderAdapter.Descriptor r = (AntClassLoaderAdapter.Descriptor)this.getCheckedRef(AntClassLoaderAdapter.Descriptor.class, "antLoaderDescriptor");
            return r.getSystemPackageRoot();
        }
        return this.systemPackageRoot;
    }

    public boolean isAddJavaLibraries() {
        if (this.isReference()) {
            AntClassLoaderAdapter.Descriptor r = (AntClassLoaderAdapter.Descriptor)this.getCheckedRef(AntClassLoaderAdapter.Descriptor.class, "antLoaderDescriptor");
            return r.isAddJavaLibraries();
        }
        return this.addJavaLibraries;
    }

    public boolean isIsolated() {
        if (this.isReference()) {
            AntClassLoaderAdapter.Descriptor r = (AntClassLoaderAdapter.Descriptor)this.getCheckedRef(AntClassLoaderAdapter.Descriptor.class, "antLoaderDescriptor");
            return r.isIsolated();
        }
        return this.isolated;
    }

    public boolean isParentFirst() {
        if (this.isReference()) {
            AntClassLoaderAdapter.Descriptor r = (AntClassLoaderAdapter.Descriptor)this.getCheckedRef(AntClassLoaderAdapter.Descriptor.class, "antLoaderDescriptor");
            return r.isParentFirst();
        }
        return this.parentFirst;
    }

    public void setAddJavaLibraries(boolean onOff) {
        this.checkAttributesAllowed();
        this.addJavaLibraries = onOff;
    }

    public void setIsolated(boolean b) {
        this.checkAttributesAllowed();
        this.isolated = b;
    }

    public void setLoaderPackageRoot(String pkgs) {
        this.checkAttributesAllowed();
        HashSet<String> set = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(pkgs, ",;:");
        while (st.hasMoreTokens()) {
            set.add(st.nextToken().trim());
        }
        this.loaderPackageRoot = set.toArray(new String[set.size()]);
    }

    public void setParentFirst(boolean b) {
        this.checkAttributesAllowed();
        this.parentFirst = b;
    }

    public void setReverseLoader(boolean b) {
        this.checkAttributesAllowed();
        this.parentFirst = !b;
    }

    public void setSystemPackageRoot(String pkgs) {
        this.checkAttributesAllowed();
        HashSet<String> set = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(pkgs, ",;:");
        while (st.hasMoreTokens()) {
            set.add(st.nextToken().trim());
        }
        this.systemPackageRoot = set.toArray(new String[set.size()]);
    }
}

