/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapter;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandler;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.adapter.AntClassLoaderAdapter;
import org.apache.tools.ant.taskdefs.classloader.adapter.SimpleClassLoaderAdapter;
import org.apache.tools.ant.taskdefs.classloader.adapter.URLClassLoaderAdapter;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public final class LoaderHandler
extends DataType
implements ClassLoaderHandler,
Cloneable {
    private static final LoaderHandler[] DEFAULT_HANDLERS = new LoaderHandler[]{new LoaderHandler("ant.clhandler.URLClassLoader", URLClassLoaderAdapter.class.getName(), URLClassLoader.class.getName()), new LoaderHandler("ant.clhandler.AntClassLoader", AntClassLoaderAdapter.class.getName(), AntClassLoader.class.getName()), new LoaderHandler("ant.clhandler.ClassLoader", SimpleClassLoaderAdapter.class.getName(), ClassLoader.class.getName())};
    private String adapter = null;
    private String desiredId = null;
    private String loader = null;

    public static void addPredefined(Project project) {
        for (int i = 0; i < DEFAULT_HANDLERS.length; ++i) {
            DEFAULT_HANDLERS[i].setDesiredId(project);
        }
    }

    public static ClassLoaderHandler[] getDefaultHandlers(Project project) {
        LoaderHandler.addPredefined(project);
        ArrayList<Object> list = new ArrayList<Object>(DEFAULT_HANDLERS.length);
        for (int i = 0; i < DEFAULT_HANDLERS.length; ++i) {
            Object o = project.getReference(LoaderHandler.DEFAULT_HANDLERS[i].desiredId);
            if (o == null || !(o instanceof LoaderHandler)) continue;
            list.add(o);
        }
        return list.toArray(new ClassLoaderHandler[list.size()]);
    }

    public static ClassLoaderHandler[] getAllHandlers(Project project) {
        LoaderHandler.addPredefined(project);
        ArrayList<Object> list = new ArrayList<Object>(DEFAULT_HANDLERS.length);
        Iterator i = project.getReferences().keySet().iterator();
        while (i.hasNext()) {
            Object o = project.getReference((String)i.next());
            if (o == null || !(o instanceof LoaderHandler) || ((LoaderHandler)o).isReference()) continue;
            list.add(o);
        }
        return list.toArray(new ClassLoaderHandler[list.size()]);
    }

    private LoaderHandler() {
    }

    public LoaderHandler(Project project) {
        this.setProject(project);
        LoaderHandler.addPredefined(project);
    }

    public LoaderHandler(Project project, Reference refid) {
        this(project);
        this.setRefid(refid);
        this.check();
    }

    private LoaderHandler(String id, String adapter, String loader) {
        this.desiredId = id;
        this.adapter = adapter;
        this.loader = loader;
        this.check();
    }

    public void check() {
        if (this.isReference()) {
            LoaderHandler r = (LoaderHandler)this.getCheckedRef(LoaderHandler.class, "LoaderHandler");
            r.check();
        }
        if (this.loader == null) {
            throw new BuildException("attribute loader is mandatory");
        }
        if (this.adapter == null) {
            throw new BuildException("attribute adapter is mandatory");
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private LoaderHandler clone(Project project) {
        LoaderHandler result = (LoaderHandler)this.clone();
        result.setProject(project);
        return result;
    }

    public String getAdapter() {
        this.check();
        if (this.isReference()) {
            LoaderHandler r = (LoaderHandler)this.getCheckedRef(LoaderHandler.class, "LoaderHandler");
            return r.getAdapter();
        }
        return this.adapter;
    }

    public ClassLoaderAdapter getAdapter(ClassloaderContext task) {
        this.check();
        if (this.isReference()) {
            LoaderHandler r = (LoaderHandler)this.getCheckedRef(LoaderHandler.class, "LoaderHandler");
            return r.getAdapter(task);
        }
        try {
            return (ClassLoaderAdapter)Class.forName(this.adapter).newInstance();
        }
        catch (Exception e) {
            task.handleError("error instantiating ClassLoaderAdapter " + this.adapter, e);
            return null;
        }
    }

    public String getLoader() {
        this.check();
        if (this.isReference()) {
            LoaderHandler r = (LoaderHandler)this.getCheckedRef(LoaderHandler.class, "LoaderHandler");
            return r.getLoader();
        }
        return this.loader;
    }

    public Class getLoaderClass(ClassloaderContext task, ClassLoader assignable, ClassLoaderAdapterAction action) {
        this.check();
        if (this.isReference()) {
            LoaderHandler r = (LoaderHandler)this.getCheckedRef(LoaderHandler.class, "LoaderHandler");
            return r.getLoaderClass(task, assignable, action);
        }
        try {
            Class<?> result = Class.forName(this.loader, true, assignable.getClass().getClassLoader());
            if (!result.isAssignableFrom(assignable.getClass())) {
                return null;
            }
            ClassLoaderAdapter adapter = this.getAdapter(task);
            if (action != null && !adapter.isSupported(action)) {
                return null;
            }
            return result;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void setAdapter(String classname) {
        this.checkAttributesAllowed();
        this.adapter = classname;
    }

    private void setDesiredId(Project project) {
        if (this.desiredId != null && project.getReference(this.desiredId) == null) {
            project.addReference(this.desiredId, (Object)this.clone(project));
        }
    }

    public void setLoader(String classname) {
        this.checkAttributesAllowed();
        this.loader = classname;
    }
}

