/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandler;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandlerSet;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.LoaderHandler;
import org.apache.tools.ant.types.Reference;

public class LoaderHandlerSet
extends DataType
implements ClassLoaderHandlerSet {
    private boolean addDefault = true;
    private boolean addAll = false;
    private final ArrayList handlerList = new ArrayList();
    private final HashSet handlerSet = new HashSet();

    private LoaderHandlerSet() {
    }

    public LoaderHandlerSet(Project project) {
        this.setProject(project);
        LoaderHandler.addPredefined(project);
    }

    public LoaderHandlerSet(Project project, Reference refid) {
        this(project);
        this.setRefid(refid);
    }

    public void addConfiguredHandler(ClassLoaderHandler handler) {
        this.checkChildrenAllowed();
        handler.check();
        if (this.handlerSet.add(handler.getLoader())) {
            this.handlerList.add(handler);
        }
    }

    public ClassLoaderHandler getHandler(ClassloaderContext task, ClassLoader loader, ClassLoaderAdapterAction action) {
        int i;
        if (this.isReference()) {
            LoaderHandlerSet r = (LoaderHandlerSet)this.getCheckedRef(LoaderHandlerSet.class, "loaderHandlerSet");
            return r.getHandler(task, loader, action);
        }
        if (this.addAll) {
            ClassLoaderHandler[] allHandlers = LoaderHandler.getAllHandlers(this.getProject());
            for (i = 0; i < allHandlers.length; ++i) {
                this.addConfiguredHandler(allHandlers[i]);
            }
            this.addAll = false;
            this.addDefault = false;
        }
        if (this.addDefault) {
            ClassLoaderHandler[] defHandlers = LoaderHandler.getDefaultHandlers(this.getProject());
            for (i = 0; i < defHandlers.length; ++i) {
                this.addConfiguredHandler(defHandlers[i]);
            }
            this.addDefault = false;
        }
        ArrayList<HandlerHolder> holderList = new ArrayList<HandlerHolder>();
        for (LoaderHandler handler : this.handlerList) {
            Class loaderClass = handler.getLoaderClass(task, loader, action);
            if (loaderClass == null) continue;
            holderList.add(new HandlerHolder(handler, loaderClass));
        }
        if (holderList.size() == 0) {
            task.handleError("No Handler found for ClassLoader " + loader.getClass().getName() + " and action " + action);
            return null;
        }
        HandlerHolder[] holders = holderList.toArray(new HandlerHolder[holderList.size()]);
        for (int current = 1; current < holders.length; ++current) {
            boolean changed = false;
            for (int sorted = 0; !changed && sorted < current; ++sorted) {
                if (!holders[sorted].loaderClass.isAssignableFrom(holders[current].loaderClass)) continue;
                HandlerHolder temp = holders[current];
                System.arraycopy(holders, sorted, holders, sorted + 1, current - sorted);
                holders[sorted] = temp;
                changed = true;
            }
        }
        return holders[0].handler;
    }

    public void setAddDefault(boolean onOff) {
        this.checkAttributesAllowed();
        this.addDefault = onOff;
    }

    public void setAddAll(boolean onOff) {
        this.checkAttributesAllowed();
        this.addAll = onOff;
    }

    public void setHandler(LoaderHandler handler) {
        this.checkAttributesAllowed();
        handler.check();
        if (this.handlerSet.add(handler.getLoader())) {
            this.handlerList.add(handler);
        }
    }

    private static class HandlerHolder {
        private final LoaderHandler handler;
        private final Class loaderClass;

        public HandlerHolder(LoaderHandler handler, Class loaderClass) {
            this.handler = handler;
            this.loaderClass = loaderClass;
        }
    }
}

