/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.HashSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandler;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderParameters;
import org.apache.tools.ant.taskdefs.classloader.adapter.SimpleClassLoaderAdapter;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.LoaderHandler;
import org.apache.tools.ant.types.Reference;

public class LoaderParameters
extends DataType
implements ClassLoaderParameters,
SimpleClassLoaderAdapter.Descriptor {
    private HashSet classAssertions = new HashSet();
    private HashSet classNonAssertions = new HashSet();
    private Boolean defaultAssertionStatus = null;
    private HashSet packageAssertions = new HashSet();
    private HashSet packageNonAssertions = new HashSet();

    public LoaderParameters(Project project) {
        this.setProject(project);
        LoaderHandler.addPredefined(project);
    }

    public LoaderParameters(Project project, Reference refid) {
        this(project);
        this.setRefid(refid);
    }

    public void addConfiguredClassAssertionStatus(AssertionStatus st) {
        this.checkChildrenAllowed();
        st.check(false);
        if (st.getStatus()) {
            this.classAssertions.add(st.getName());
        } else {
            this.classNonAssertions.add(st.getName());
        }
    }

    public void addConfiguredPackageAssertionStatus(AssertionStatus st) {
        this.checkChildrenAllowed();
        st.check(true);
        if (st.getStatus()) {
            this.packageAssertions.add(st.getName());
        } else {
            this.packageNonAssertions.add(st.getName());
        }
    }

    public String[] getClassAssertions(boolean status) {
        HashSet s;
        if (this.isReference()) {
            SimpleClassLoaderAdapter.Descriptor r = (SimpleClassLoaderAdapter.Descriptor)this.getCheckedRef(SimpleClassLoaderAdapter.Descriptor.class, "loaderDescriptor");
            return r.getClassAssertions(status);
        }
        HashSet hashSet = s = status ? this.classAssertions : this.classNonAssertions;
        if (s.size() == 0) {
            return null;
        }
        return s.toArray(new String[s.size()]);
    }

    public Boolean getDefaultAssertionStatus() {
        if (this.isReference()) {
            SimpleClassLoaderAdapter.Descriptor r = (SimpleClassLoaderAdapter.Descriptor)this.getCheckedRef(SimpleClassLoaderAdapter.Descriptor.class, "loaderDescriptor");
            return r.getDefaultAssertionStatus();
        }
        return this.defaultAssertionStatus;
    }

    public ClassLoaderHandler getDefaultHandler() {
        if (this.isReference()) {
            ClassLoaderParameters r = (ClassLoaderParameters)this.getCheckedRef(ClassLoaderParameters.class, "loaderDescriptor");
            return r.getDefaultHandler();
        }
        return (ClassLoaderHandler)this.getProject().getReference("ant.clhandler.URLClassLoader");
    }

    public ClassLoaderParameters getParameters() {
        if (this.isReference()) {
            return (ClassLoaderParameters)this.getCheckedRef(ClassLoaderParameters.class, "loaderDescriptor");
        }
        return this;
    }

    public String[] getPackageAssertions(boolean status) {
        HashSet s;
        if (this.isReference()) {
            SimpleClassLoaderAdapter.Descriptor r = (SimpleClassLoaderAdapter.Descriptor)this.getCheckedRef(SimpleClassLoaderAdapter.Descriptor.class, "loaderDescriptor");
            return r.getPackageAssertions(status);
        }
        HashSet hashSet = s = status ? this.packageAssertions : this.packageNonAssertions;
        if (s.size() == 0) {
            return null;
        }
        return s.toArray(new String[s.size()]);
    }

    public void setDefaultAssertionStatus(Boolean onOff) {
        this.checkAttributesAllowed();
        this.defaultAssertionStatus = onOff;
    }

    public class AssertionStatus {
        private String name = null;
        private boolean status = false;

        void check(boolean pkg) {
            if (this.name == null) {
                throw new BuildException("attribute " + (pkg ? "package" : "class") + " is mandatory");
            }
        }

        public boolean getStatus() {
            return this.status;
        }

        public String getName() {
            return this.name;
        }

        public void setStatus(boolean onOff) {
            this.status = onOff;
        }

        public void setClass(String name) {
            this.name = name;
        }

        public void setPackage(String name) {
            this.name = name;
        }
    }
}

