/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;

public class LoaderRef
extends DataType {
    private boolean failOnError = true;
    private LoaderSpec loader = null;
    private String loaderRef = null;

    private LoaderRef() {
    }

    public LoaderRef(Project project) {
        this.setProject(project);
    }

    public LoaderRef(Project project, String ref) {
        this(project);
        Object r = this.getProject().getReference(ref);
        if (r == null) {
            try {
                this.loader = new LoaderSpec(ref);
            }
            catch (Exception ex) {
                this.loaderRef = ref;
            }
        } else if (r instanceof LoaderRef) {
            this.setRefid(new Reference(ref));
        } else if (r instanceof ClassLoader) {
            this.loaderRef = ref;
        } else {
            throw new BuildException("Reference " + ref + " denotes an object of class " + r.getClass().getName() + " which is neither a org.apache.tools.ant.types.LoaderRef nor a java.lang.ClassLoader");
        }
    }

    public ClassLoader getClassLoader(LoaderSpec defaultLoader) {
        return this.getClassLoader(defaultLoader, this.failOnError, true);
    }

    public ClassLoader getClassLoader(LoaderSpec defaultLoader, boolean failOnError, boolean allowNullRef) {
        Object obj = null;
        if (this.isReference()) {
            return this.getRef().getClassLoader(defaultLoader, failOnError, allowNullRef);
        }
        if (this.loaderRef != null) {
            obj = this.getProject().getReference(this.loaderRef);
            if (obj == null) {
                if (allowNullRef) {
                    return null;
                }
                this.handleError("Referenced object " + this.loaderRef + " not found", failOnError);
                return null;
            }
            if (!(obj instanceof ClassLoader)) {
                this.handleError("Referenced object " + this.loaderRef + " is not a ClassLoader: " + obj.getClass().getName(), failOnError);
                return null;
            }
            return (ClassLoader)obj;
        }
        if (this.loader != null) {
            return this.loader.getClassLoader(this);
        }
        if (defaultLoader != null) {
            return defaultLoader.getClassLoader(this);
        }
        return null;
    }

    public ClassLoader getClassLoaderOrFallback(LoaderSpec defaultLoader, boolean failOnError, boolean allowNullRef) {
        Object obj = null;
        if (this.isReference()) {
            return this.getRef().getClassLoaderOrFallback(defaultLoader, failOnError, allowNullRef);
        }
        if (this.loaderRef != null) {
            obj = this.getProject().getReference(this.loaderRef);
            if (obj == null) {
                if (allowNullRef) {
                    return null;
                }
                this.handleError("Referenced object " + this.loaderRef + " not found", failOnError);
                return null;
            }
            if (!(obj instanceof ClassLoader)) {
                this.handleError("Referenced object " + this.loaderRef + " is not a ClassLoader: " + obj.getClass().getName(), failOnError);
                return null;
            }
            return (ClassLoader)obj;
        }
        if (this.loader != null) {
            return this.loader.getClassloaderOrFallback(this);
        }
        if (defaultLoader != null) {
            return defaultLoader.getClassloaderOrFallback(this);
        }
        return null;
    }

    public String getLoaderId() {
        if (this.isReference()) {
            return this.getRef().getLoaderId();
        }
        if (this.loaderRef != null) {
            return this.loaderRef;
        }
        if (this.loader != null) {
            return LoaderSpec.MAGIC_NAMES[this.loader.getIndex()];
        }
        return null;
    }

    public String getName() {
        if (this.isReference()) {
            return this.getRef().getName();
        }
        if (this.loaderRef != null) {
            return this.loaderRef;
        }
        if (this.loader != null) {
            return this.loader.toString();
        }
        return null;
    }

    private LoaderRef getRef() {
        return (LoaderRef)((Object)this.getCheckedRef(LoaderRef.class, "loaderRef"));
    }

    public void handleError(String msg) {
        this.handleError(msg, null, this.failOnError);
    }

    public void handleError(String msg, boolean fail) {
        this.handleError(msg, null, fail);
    }

    public void handleError(String msg, Throwable ex) {
        this.handleError(msg, null, this.failOnError);
    }

    public void handleError(String msg, Throwable ex, boolean fail) {
        if (msg == null && ex != null) {
            msg = ex.getMessage();
        }
        if (fail) {
            throw new BuildException(msg, ex);
        }
        this.log("Error: " + msg, 0);
    }

    public boolean isStandardLoader(int id) {
        if (this.isReference()) {
            return this.getRef().isStandardLoader(id);
        }
        if (this.loaderRef != null) {
            return false;
        }
        if (this.loader != null) {
            return this.loader.getIndex() == id;
        }
        return false;
    }

    public boolean equalsSysLoader() {
        if (this.isReference()) {
            return this.getRef().equalsSysLoader();
        }
        if (this.loaderRef == null && this.loader != null && (this.loader.getIndex() == 0 || this.loader.getIndex() == 5 || this.loader.getIndex() == 1)) {
            return true;
        }
        ClassLoader cl = this.getClassLoader(null);
        if (cl == null) {
            return false;
        }
        ClassLoader scl = new LoaderSpec(LoaderSpec.MAGIC_NAMES[0]).getClassLoader(this);
        if (scl == cl) {
            return true;
        }
        cl = new LoaderSpec(LoaderSpec.MAGIC_NAMES[5]).getClassLoader(this);
        if (scl == cl) {
            return true;
        }
        cl = new LoaderSpec(LoaderSpec.MAGIC_NAMES[1]).getClassLoader(this);
        return scl == cl;
    }

    public boolean isResetPossible() {
        if (this.isReference()) {
            return this.getRef().isResetPossible();
        }
        if (this.loaderRef != null) {
            return true;
        }
        if (this.loader != null) {
            return this.loader.isResetPossible();
        }
        return false;
    }

    public void setClassLoader(ClassLoader classloader) {
        if (this.isReference()) {
            this.getRef().setClassLoader(classloader);
        } else if (this.loaderRef != null) {
            this.getProject().addReference(this.loaderRef, (Object)classloader);
        } else if (this.loader != null) {
            this.loader.set(this, classloader);
        }
    }

    public void setFailonerror(boolean onOff) {
        this.checkAttributesAllowed();
        this.failOnError = onOff;
    }

    public void setLoader(LoaderSpec spec) {
        this.checkAttributesAllowed();
        this.loader = spec;
    }

    public void setLoaderRef(Reference id) {
        this.checkAttributesAllowed();
        String sid = id.getRefId();
        for (int i = 0; i < LoaderSpec.MAGIC_NAMES.length; ++i) {
            if (!sid.equals(LoaderSpec.MAGIC_NAMES[i])) continue;
            this.setLoader(new LoaderSpec(new LoaderSpec().getValues()[i]));
            return;
        }
        this.loaderRef = id.getRefId();
    }

    public static class LoaderSpec
    extends EnumeratedAttribute {
        public static final int CORE = 0;
        public static final int SYSTEM = 1;
        public static final int CURRENT = 2;
        public static final int NONE = 3;
        public static final int THREAD = 4;
        public static final int PROJECT = 5;
        public static final String[] MAGIC_NAMES = new String[]{"ant.coreLoader", null, null, null, null, null};

        public LoaderSpec() {
        }

        public LoaderSpec(String value) {
            this.setValue(value);
        }

        public ClassLoader getClassLoader(LoaderRef type) {
            switch (this.getIndex()) {
                case 0: {
                    return type.getProject().getCoreLoader();
                }
                case 1: {
                    return ClassLoader.getSystemClassLoader();
                }
                case 2: {
                    return ((Object)((Object)type)).getClass().getClassLoader();
                }
                case 4: {
                    return Thread.currentThread().getContextClassLoader();
                }
                case 5: {
                    return type.getProject().getClass().getClassLoader();
                }
            }
            return null;
        }

        public ClassLoader getClassloaderOrFallback(LoaderRef type) {
            switch (this.getIndex()) {
                case 0: {
                    ClassLoader result = type.getProject().getCoreLoader();
                    if (result != null) {
                        return result;
                    }
                    return new LoaderSpec("PROJECT").getClassloaderOrFallback(type);
                }
            }
            return this.getClassLoader(type);
        }

        public boolean isResetPossible() {
            switch (this.getIndex()) {
                case 0: 
                case 4: {
                    return true;
                }
            }
            return MAGIC_NAMES[this.getIndex()] != null;
        }

        public void set(LoaderRef type, ClassLoader loader) {
            switch (this.getIndex()) {
                case 4: {
                    Thread.currentThread().setContextClassLoader(loader);
                    break;
                }
                case 0: {
                    type.getProject().setCoreLoader(loader);
                    break;
                }
            }
            if (MAGIC_NAMES[this.getIndex()] != null) {
                type.getProject().addReference(MAGIC_NAMES[this.getIndex()], (Object)loader);
            }
        }

        public String[] getValues() {
            return new String[]{"core", "system", "current", "none", "thread", "project"};
        }

        public String toString() {
            switch (this.getIndex()) {
                case 0: {
                    return "CoreLoader";
                }
                case 1: {
                    return "SystemClassLoader";
                }
                case 2: {
                    return "Current ClassLoader";
                }
                case 4: {
                    return "ThreadContextClassLoader";
                }
                case 5: {
                    return "ProjectClassLoader";
                }
            }
            return null;
        }
    }
}

