/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.URLUtils;

public class URLPath
extends DataType
implements Cloneable {
    private ArrayList elements;

    private static void addUnlessPresent(ArrayList v, Set set, String s) {
        if (set.add(s)) {
            v.add(s);
        }
    }

    private static String resolveURL(Project project, String relativeName) {
        if (project != null) {
            try {
                return URLUtils.getURLUtils().resolve(relativeName, project.getBaseDir());
            }
            catch (MalformedURLException murlex) {
                return relativeName;
            }
        }
        return relativeName;
    }

    public URLPath(Project project) {
        this.setProject(project);
        this.elements = new ArrayList();
    }

    public URLPath(Project p, String path) {
        this(p);
        this.createPathElement().setPath(path);
    }

    public void addDirset(DirSet dset) {
        this.checkChildrenAllowed();
        this.elements.add(dset);
        this.setChecked(false);
    }

    public void addExisting(URLPath source) {
        this.addExisting(source, false);
    }

    public void addExisting(URLPath source, boolean tryUserDir) {
        String[] list = source.list();
        File userDir = tryUserDir ? new File(System.getProperty("user.dir")) : null;
        for (int i = 0; i < list.length; ++i) {
            File f = null;
            f = this.getProject() != null ? this.getProject().resolveFile(list[i]) : new File(list[i]);
            if (tryUserDir && !f.exists()) {
                f = new File(userDir, list[i]);
            }
            if (f.exists()) {
                this.setLocation(f.toString());
                continue;
            }
            this.log("dropping " + f + " from path as it doesn't exist", 3);
        }
    }

    public void addExtdirs(Path extdirs) {
        this.checkChildrenAllowed();
        if (extdirs == null) {
            String extProp = System.getProperty("java.ext.dirs");
            if (extProp != null) {
                extdirs = new Path(this.getProject(), extProp);
            } else {
                return;
            }
        }
        String[] dirs = extdirs.list();
        for (int i = 0; i < dirs.length; ++i) {
            File dir = this.getProject().resolveFile(dirs[i]);
            if (!dir.exists() || !dir.isDirectory()) continue;
            FileSet fs = new FileSet();
            fs.setDir(dir);
            fs.setIncludes("*");
            this.addFileset(fs);
        }
    }

    public void addFilelist(FileList fl) {
        this.checkChildrenAllowed();
        this.elements.add(fl);
        this.setChecked(false);
    }

    public void addFileset(FileSet fs) {
        this.checkChildrenAllowed();
        this.elements.add(fs);
        this.setChecked(false);
    }

    public void addJavaRuntime() {
        this.createPath().addJavaRuntime();
    }

    public void addPath(Path path) {
        this.checkChildrenAllowed();
        this.elements.add(path);
        this.setChecked(false);
    }

    public void addReference(Reference id) {
        this.checkChildrenAllowed();
        this.elements.add(id);
        this.setChecked(false);
    }

    private Path addToPath(Path result) {
        if (result == null) {
            result = new Path(this.getProject());
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Object o = this.elements.get(i);
            if (o instanceof Reference) {
                Reference r = (Reference)o;
                o = r.getReferencedObject(this.getProject());
            }
            if (o instanceof URLPathElement) {
                ((URLPathElement)o).addToPath(result);
                continue;
            }
            if (o instanceof URLPath) {
                ((URLPath)o).addToPath(result);
                continue;
            }
            if (o instanceof Path) {
                result.add((Path)o);
                continue;
            }
            if (o instanceof DirSet) {
                result.addDirset((DirSet)o);
                continue;
            }
            if (o instanceof FileSet) {
                result.addFileset((FileSet)o);
                continue;
            }
            if (!(o instanceof FileList)) continue;
            result.addFilelist((FileList)o);
        }
        return result;
    }

    private void addUnlessPresent(ArrayList v, Set set, File dir, String[] s) {
        for (int j = 0; j < s.length; ++j) {
            try {
                String absolutePath = URLUtils.getURLUtils().resolve(s[j], dir);
                URLPath.addUnlessPresent(v, set, absolutePath);
                continue;
            }
            catch (MalformedURLException murlex) {
                URLPath.addUnlessPresent(v, set, s[j]);
            }
        }
    }

    public void addURLPath(URLPath path) {
        this.checkChildrenAllowed();
        this.elements.add(path);
        this.setChecked(false);
    }

    public void append(URLPath other) {
        if (other == null) {
            return;
        }
        Iterator i = other.elements.iterator();
        while (i.hasNext()) {
            this.elements.add(i.next());
        }
        this.setChecked(false);
    }

    public Object clone() {
        try {
            URLPath p = (URLPath)super.clone();
            p.elements = (ArrayList)this.elements.clone();
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public URLPath concatSystemClasspath() {
        return this.concatSystemClasspath("last");
    }

    public URLPath concatSystemClasspath(String defValue) {
        String o;
        URLPath result = new URLPath(this.getProject());
        String order = defValue;
        if (this.getProject() != null && (o = this.getProject().getProperty("build.sysclasspath")) != null) {
            order = o;
        }
        if (order.equals("only")) {
            result.addExisting(new URLPath(null, System.getProperty("java.class.path")), true);
        } else if (order.equals("first")) {
            result.addExisting(new URLPath(null, System.getProperty("java.class.path")), true);
            result.addExisting(this);
        } else if (order.equals("ignore")) {
            result.addExisting(this);
        } else {
            if (!order.equals("last")) {
                this.log("invalid value for build.sysclasspath: " + order, 1);
            }
            result.addExisting(this);
            result.addExisting(new URLPath(null, System.getProperty("java.class.path")), true);
        }
        return result;
    }

    public Path createPath() {
        this.checkChildrenAllowed();
        Path p = new Path(this.getProject());
        this.elements.add(p);
        this.setChecked(false);
        return p;
    }

    public Path.PathElement createPathElement() {
        this.checkChildrenAllowed();
        return this.createPath().createPathElement();
    }

    public URLPath createUrlpath() {
        this.checkChildrenAllowed();
        URLPath p = new URLPath(this.getProject());
        this.elements.add(p);
        this.setChecked(false);
        return p;
    }

    public URLPathElement createUrlpathelement() {
        this.checkChildrenAllowed();
        URLPathElement pe = new URLPathElement();
        this.elements.add(pe);
        return pe;
    }

    public void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        Method docrMethod;
        if (this.isChecked()) {
            return;
        }
        try {
            docrMethod = DataType.class.getDeclaredMethod("dieOnCircularReference", Stack.class, Project.class);
        }
        catch (SecurityException e) {
            throw new BuildException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BuildException("Possible Version Conflict, oata.types.DataType has no dieOnCircularReferenceMethod", (Throwable)e);
        }
        docrMethod.setAccessible(true);
        for (Object o : this.elements) {
            while (o instanceof Reference) {
                o = ((Reference)o).getReferencedObject(p);
            }
            if (!(o instanceof DataType)) continue;
            if (stk.contains(o)) {
                throw this.circularReference();
            }
            stk.push(o);
            try {
                docrMethod.invoke(o, stk, p);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            stk.pop();
        }
        this.setChecked(true);
    }

    public String[] list() {
        ArrayList result = new ArrayList(2 * this.elements.size());
        HashSet set = new HashSet();
        for (int i = 0; i < this.elements.size(); ++i) {
            File dir;
            URLPath p;
            Object o = this.elements.get(i);
            if (o instanceof Reference) {
                Reference r = (Reference)o;
                o = r.getReferencedObject(this.getProject());
            }
            if (o instanceof URLPathElement) {
                String[] parts = ((URLPathElement)o).getParts();
                if (parts == null) {
                    throw new BuildException("You must either set location or path on <urlpathelement>");
                }
                for (int j = 0; j < parts.length; ++j) {
                    URLPath.addUnlessPresent(result, set, URLPath.resolveURL(this.getProject(), parts[j]));
                }
                continue;
            }
            if (o instanceof URLPath) {
                p = (URLPath)o;
                if (p.getProject() == null) {
                    p.setProject(this.getProject());
                }
                String[] parts = p.list();
                for (int j = 0; j < parts.length; ++j) {
                    URLPath.addUnlessPresent(result, set, URLPath.resolveURL(p.getProject(), parts[j]));
                }
                continue;
            }
            if (o instanceof Path) {
                p = (Path)o;
                if (p.getProject() == null) {
                    p.setProject(this.getProject());
                }
                String[] parts = p.list();
                for (int j = 0; j < parts.length; ++j) {
                    URLPath.addUnlessPresent(result, set, URLPath.resolveURL(p.getProject(), parts[j]));
                }
                continue;
            }
            if (o instanceof DirSet) {
                DirSet dset = (DirSet)o;
                DirectoryScanner ds = dset.getDirectoryScanner(this.getProject());
                String[] s = ds.getIncludedDirectories();
                dir = dset.getDir(this.getProject());
                this.addUnlessPresent(result, set, dir, s);
                continue;
            }
            if (o instanceof FileSet) {
                FileSet fs = (FileSet)o;
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] s = ds.getIncludedFiles();
                dir = fs.getDir(this.getProject());
                this.addUnlessPresent(result, set, dir, s);
                continue;
            }
            if (!(o instanceof FileList)) continue;
            FileList fl = (FileList)o;
            String[] s = fl.getFiles(this.getProject());
            File dir2 = fl.getDir(this.getProject());
            this.addUnlessPresent(result, set, dir2, s);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setLocation(String location) {
        this.checkAttributesAllowed();
        this.createUrlpathelement().setLocation(location);
    }

    public void setPath(String path) {
        this.checkAttributesAllowed();
        this.createPathElement().setPath(path);
    }

    public void setRefid(Reference r) {
        if (!this.elements.isEmpty()) {
            throw this.tooManyAttributes();
        }
        this.elements.add(r);
        super.setRefid(r);
    }

    public void setUrlpath(String path) {
        this.checkAttributesAllowed();
        this.createUrlpathelement().setPath(path);
    }

    public int size() {
        return this.list().length;
    }

    public Path toPath() throws BuildException {
        return this.addToPath(null);
    }

    public String toString() {
        String[] list = this.list();
        if (list.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(list[0].toString());
        for (int i = 1; i < list.length; ++i) {
            result.append(';');
            result.append(list[i]);
        }
        return result.toString();
    }

    public String translateFile(String source) {
        if (source == null) {
            return null;
        }
        try {
            if (!URLUtils.getURLUtils().isURL(source)) {
                source = this.getProject().resolveFile(source).getAbsolutePath();
            }
            return URLUtils.getURLUtils().resolve(source, this.getProject().getBaseDir());
        }
        catch (MalformedURLException murlex) {
            return source;
        }
    }

    protected String[] translateUrlPath(String source) {
        ArrayList<String> result = new ArrayList<String>();
        if (source == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(source, ";");
        while (st.hasMoreTokens()) {
            String pathElement = st.nextToken().trim();
            if (pathElement.length() <= 0 || (pathElement = this.translateFile(pathElement)) == null) continue;
            result.add(pathElement);
        }
        return result.toArray(new String[result.size()]);
    }

    public class URLPathElement {
        private String[] parts = null;

        protected void addToPath(Path result) {
            if (this.parts == null) {
                return;
            }
            for (int i = 0; i < this.parts.length; ++i) {
                result.createPathElement().setLocation(URLUtils.getURLUtils().createFile(this.parts[i]));
            }
        }

        public String[] getParts() {
            return this.parts;
        }

        public void setLocation(String loc) {
            if (this.parts != null) {
                throw new BuildException("either location or path can be defined");
            }
            if (loc != null && (loc = URLPath.this.translateFile(loc)) != null) {
                this.parts = new String[]{loc};
            }
        }

        public void setPath(String path) {
            if (this.parts != null) {
                throw new BuildException("either location or path can be defined");
            }
            this.parts = URLPath.this.translateUrlPath(path);
        }
    }
}

