/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderURLUtil;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.util.FileUtils;

public final class URLUtils
implements ClassloaderURLUtil {
    private static final FileUtils FILEUTILS = FileUtils.newFileUtils();
    private static final boolean ON_NETWARE = Os.isFamily((String)"netware");
    private static URLUtils singleton = new URLUtils();

    public static URLUtils getURLUtils() {
        return singleton;
    }

    public File createFile(String fileOrURL) {
        if (this.isURL(fileOrURL)) {
            return new File(FILEUTILS.fromURI(fileOrURL));
        }
        return new File(fileOrURL);
    }

    public URL createURL(String fileOrURL) throws MalformedURLException {
        if (this.isURL(fileOrURL)) {
            return new URL(this.normalize(fileOrURL));
        }
        return FILEUTILS.getFileURL(new File(fileOrURL));
    }

    public boolean isAbsolute(String fileOrURL) throws MalformedURLException {
        if (this.isURL(fileOrURL)) {
            URL url = new URL(this.transformFileSep(fileOrURL));
            String urlStr = url.toString();
            if (url.getProtocol() != null) {
                urlStr = urlStr.substring(url.getProtocol().length() + 1);
            }
            return urlStr.startsWith("/");
        }
        return new File(fileOrURL).isAbsolute();
    }

    public boolean isFileOrFileURL(String fileOrURL) {
        if (!this.isURL(fileOrURL)) {
            return true;
        }
        return fileOrURL.startsWith("file:");
    }

    public boolean isURL(String fileOrURL) {
        String x = this.transformFileSep(fileOrURL);
        if (x.startsWith("/")) {
            return false;
        }
        try {
            URL url = new URL(this.transformFileSep(fileOrURL));
            return url.getProtocol() != null;
        }
        catch (MalformedURLException murlex) {
            return false;
        }
    }

    public String normalize(String fileOrURL) throws MalformedURLException {
        if (!this.isURL(fileOrURL)) {
            return FILEUTILS.normalize(fileOrURL).toString();
        }
        String orig = fileOrURL;
        fileOrURL = this.transformFileSep(fileOrURL);
        fileOrURL = new URL(fileOrURL).toString();
        String root = fileOrURL.substring(0, fileOrURL.indexOf(58) + 1);
        fileOrURL = fileOrURL.substring(root.length());
        while (fileOrURL.startsWith("/")) {
            root = root + "/";
            fileOrURL = fileOrURL.substring(1);
        }
        int colon = fileOrURL.indexOf(58);
        if (colon >= 0) {
            if (ON_NETWARE) {
                root = root + fileOrURL.substring(0, colon + 1);
                fileOrURL = fileOrURL.substring(colon + 1);
            } else if (File.separatorChar == '\\' && File.pathSeparatorChar == ';' && colon == 1 && Character.isLetter(fileOrURL.charAt(0))) {
                root = root + fileOrURL.substring(0, 2);
                fileOrURL = fileOrURL.substring(2);
            }
            while (fileOrURL.startsWith("/")) {
                root = root + "/";
                fileOrURL = fileOrURL.substring(1);
            }
        }
        Stack<String> s = new Stack<String>();
        StringTokenizer tok = new StringTokenizer(fileOrURL, "/");
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() == 0) {
                    throw new BuildException("Cannot resolve path " + orig);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuffer sb = new StringBuffer(fileOrURL.length());
        sb.append(root);
        boolean isFirst = true;
        for (String x : s) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append('/');
            }
            sb.append(x);
        }
        if (fileOrURL.endsWith("/") && sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    public String resolve(String fileOrURL, File dir) throws MalformedURLException {
        if (this.isAbsolute(fileOrURL)) {
            return this.createURL(fileOrURL).toString();
        }
        if (!this.isFileOrFileURL(fileOrURL)) {
            return fileOrURL;
        }
        if (this.isURL(fileOrURL)) {
            String file = FILEUTILS.fromURI(this.transformFileSep(fileOrURL));
            return this.createURL(new File(dir, file).toString()).toString();
        }
        return this.createURL(new File(dir, fileOrURL).toString()).toString();
    }

    public String transformFileSep(String fileOrURL) {
        return fileOrURL.replace('\\', '/');
    }

    private URLUtils() {
    }
}

