/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.aliyun.ons.impl;

import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnsConfig {
    static final Logger log = LoggerFactory.getLogger(OnsConfig.class);
    private static final String PROP_EVENT_consumerGroup = "event.consumerGroup";
    private static final String PROP_EVENT_producerGroup = "event.producerGroup";
    private static final String PROP_EVENT_consumeThreadNums = "event.consumeThreadNums";
    private static final String PROP_EVENT_maxReconsumeTimes = "event.maxReconsumeTimes";
    private final String channelName;
    private final String server;
    private final String accessKey;
    private final String secretKey;
    private final long timeout;
    private String producerGroup;
    private String consumerGroup;
    private final int consumeThreadNums;
    private final int maxReconsumeTimes;
    private final CloudProps cloudProps;

    public OnsConfig(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        this.server = cloudProps.getEventServer();
        this.channelName = cloudProps.getEventChannel();
        this.accessKey = cloudProps.getEventAccessKey();
        this.secretKey = cloudProps.getEventSecretKey();
        this.timeout = cloudProps.getEventPublishTimeout();
        this.consumeThreadNums = Integer.valueOf(cloudProps.getValue(PROP_EVENT_consumeThreadNums, "0"));
        this.maxReconsumeTimes = Integer.valueOf(cloudProps.getValue(PROP_EVENT_maxReconsumeTimes, "0"));
        this.producerGroup = cloudProps.getValue(PROP_EVENT_producerGroup);
        this.consumerGroup = cloudProps.getValue(PROP_EVENT_consumerGroup);
        if (Utils.isEmpty((String)this.producerGroup)) {
            this.producerGroup = "DEFAULT";
        }
        if (Utils.isEmpty((String)this.consumerGroup)) {
            this.consumerGroup = Solon.cfg().appGroup() + "_" + Solon.cfg().appName();
        }
        log.trace("producerGroup=" + this.producerGroup);
        log.trace("consumerGroup=" + this.consumerGroup);
    }

    public CloudProps getCloudProps() {
        return this.cloudProps;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public Properties getProducerProperties() {
        Properties producer = this.getBaseProperties();
        producer.put("GROUP_ID", this.producerGroup);
        producer.put("SendMsgTimeoutMillis", (Object)this.timeout);
        return producer;
    }

    public Properties getConsumerProperties(String consumerGroupId) {
        Properties consumer = this.getBaseProperties();
        consumer.put("GROUP_ID", consumerGroupId);
        consumer.put("MessageModel", "CLUSTERING");
        if (this.consumeThreadNums > 0) {
            consumer.put("ConsumeThreadNums", (Object)this.consumeThreadNums);
        }
        if (this.maxReconsumeTimes > 0) {
            consumer.put("maxReconsumeTimes", (Object)this.maxReconsumeTimes);
        }
        return consumer;
    }

    public Properties getBaseProperties() {
        Properties properties = new Properties();
        if (Utils.isNotEmpty((String)this.accessKey)) {
            properties.put("AccessKey", this.accessKey);
        }
        if (Utils.isNotEmpty((String)this.secretKey)) {
            properties.put("SecretKey", this.secretKey);
        }
        properties.put("NAMESRV_ADDR", this.server);
        return properties;
    }
}

