/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.aliyun.ons.impl;

import com.aliyun.openservices.ons.api.bean.ConsumerBean;
import com.aliyun.openservices.ons.api.bean.Subscription;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.noear.solon.Utils;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.extend.aliyun.ons.impl.OnsConfig;
import org.noear.solon.cloud.extend.aliyun.ons.impl.OnsConsumerHandler;
import org.noear.solon.cloud.model.EventObserverMap;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnsConsumer
implements Closeable {
    static Logger log = LoggerFactory.getLogger(OnsConsumer.class);
    private final OnsConfig config;
    private ConsumerBean consumerOfCluster;
    private ConsumerBean consumerOfInstance;

    public OnsConsumer(OnsConfig config) {
        this.config = config;
    }

    public void init(CloudEventObserverManger observerManger) {
        if (this.consumerOfCluster != null) {
            return;
        }
        Utils.locker().lock();
        try {
            if (this.consumerOfCluster != null) {
                return;
            }
            this.consumerOfCluster = this.buildConsumer(observerManger, this.config.getConsumerGroup(), EventLevel.cluster);
            this.consumerOfInstance = this.buildConsumer(observerManger, Instance.local().serviceAndAddress(), EventLevel.instance);
        }
        finally {
            Utils.locker().unlock();
        }
    }

    private ConsumerBean buildConsumer(CloudEventObserverManger observerManger, String consumerGroup, EventLevel eventLevel) {
        ConsumerBean consumer = new ConsumerBean();
        consumer.setProperties(this.config.getConsumerProperties(consumerGroup));
        OnsConsumerHandler handler = new OnsConsumerHandler(this.config, observerManger);
        HashMap<Subscription, OnsConsumerHandler> subscriptionTable = new HashMap<Subscription, OnsConsumerHandler>();
        for (String topic : observerManger.topicAll()) {
            EventObserverMap tagsObserverMap = observerManger.topicOf(topic);
            Collection tags = tagsObserverMap.getTagsByLevel(eventLevel);
            if (tags.size() <= 0) continue;
            String tagsExpr = String.join((CharSequence)"||", tags);
            Subscription subscription = new Subscription();
            subscription.setTopic(topic);
            if (tags.contains("*")) {
                subscription.setExpression("*");
            } else {
                subscription.setExpression(tagsExpr);
            }
            subscriptionTable.put(subscription, handler);
            log.trace("Ons consumer will subscribe [" + topic + "(" + tagsExpr + ")] ok!");
        }
        consumer.setSubscriptionTable(subscriptionTable);
        consumer.start();
        if (consumer.isStarted()) {
            log.trace("Ons consumer started!");
        } else {
            log.warn("Ons consumer start failure!");
        }
        return consumer;
    }

    @Override
    public void close() throws IOException {
        if (this.consumerOfCluster != null) {
            this.consumerOfCluster.shutdown();
        }
        if (this.consumerOfInstance != null) {
            this.consumerOfInstance.shutdown();
        }
    }
}

