/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.aliyun.ons.impl;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import java.util.Map;
import java.util.Properties;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.aliyun.ons.impl.OnsConfig;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventObserver;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnsConsumerHandler
implements MessageListener {
    static final Logger log = LoggerFactory.getLogger(OnsConsumerHandler.class);
    private CloudEventObserverManger observerManger;
    private OnsConfig config;

    public OnsConsumerHandler(OnsConfig config, CloudEventObserverManger observerManger) {
        this.observerManger = observerManger;
        this.config = config;
    }

    public Action consume(Message message, ConsumeContext consumeContext) {
        boolean isOk = true;
        try {
            String topicNew = message.getTopic();
            String group = null;
            String topic = null;
            if (topicNew.contains("--")) {
                group = topicNew.split("--")[0];
                topic = topicNew.split("--")[1];
            } else {
                topic = topicNew;
            }
            Event event = new Event(topic, new String(message.getBody()));
            event.key(message.getKey());
            event.tags(message.getTag());
            event.times(message.getReconsumeTimes());
            event.channel(this.config.getChannelName());
            if (Utils.isNotEmpty((String)group)) {
                event.group(group);
            }
            if (Utils.isNotEmpty((Properties)message.getUserProperties())) {
                for (Map.Entry<Object, Object> kv : message.getUserProperties().entrySet()) {
                    String k;
                    if (!(kv.getKey() instanceof String) || !(kv.getValue() instanceof String) || !(k = (String)kv.getKey()).startsWith("!")) continue;
                    event.meta().put(k.substring(1), (String)kv.getValue());
                }
            }
            isOk = isOk && this.onReceive(event, topicNew);
        }
        catch (Throwable e) {
            isOk = false;
            log.warn(e.getMessage(), e);
        }
        if (isOk) {
            return Action.CommitMessage;
        }
        return Action.ReconsumeLater;
    }

    protected boolean onReceive(Event event, String topicNew) throws Throwable {
        boolean isOk = true;
        EventObserver handler = null;
        if (Utils.isEmpty((String)event.tags())) {
            handler = this.observerManger.getByTopicAndTag(topicNew, "*");
        } else {
            handler = this.observerManger.getByTopicAndTag(topicNew, event.tags());
            if (handler == null) {
                handler = this.observerManger.getByTopicAndTag(topicNew, "*");
            }
        }
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }
}

